/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.stirdrem.overgeared.util.QualityHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")}, cancellable=true)
    private void insertQualityTooltip(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            MutableComponent qualityComponent;
            String quality;
            switch (quality = stack.m_41783_().m_128461_("ForgingQuality")) {
                case "poor": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.poor").m_130940_(ChatFormatting.RED);
                    break;
                }
                case "well": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.well").m_130940_(ChatFormatting.YELLOW);
                    break;
                }
                case "expert": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.expert").m_130940_(ChatFormatting.BLUE);
                    break;
                }
                case "perfect": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.perfect").m_130940_(ChatFormatting.GOLD);
                    break;
                }
                default: {
                    MutableComponent mutableComponent = qualityComponent = null;
                }
            }
            if (qualityComponent != null) {
                ArrayList<Object> tooltip = (ArrayList<MutableComponent>)cir.getReturnValue();
                tooltip = tooltip == null ? new ArrayList<MutableComponent>() : new ArrayList(tooltip);
                int insertPos = Math.min(1, tooltip.size());
                tooltip.add(insertPos, qualityComponent);
                cir.setReturnValue(tooltip);
            }
        }
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDurability(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_().m_41465_()) {
            float multiplier = QualityHelper.getQualityMultiplier(stack);
            int baseDurability = stack.m_41720_().m_41462_();
            cir.setReturnValue((Object)((int)((float)baseDurability * multiplier)));
        }
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyMiningSpeed(BlockState state, CallbackInfoReturnable<Float> cir) {
        ItemStack stack = (ItemStack)this;
        float baseSpeed = cir.getReturnValueF();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            float multiplier = QualityHelper.getQualityMultiplier(stack);
            cir.setReturnValue((Object)Float.valueOf(baseSpeed * multiplier));
        }
    }

    @Inject(method={"getMaxDamage()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDurabilityBasedOnQuality(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (!stack.m_41763_()) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            float multiplier = QualityHelper.getQualityMultiplier(stack);
            int baseDurability = stack.m_41720_().m_41462_();
            int modifiedDurability = (int)((float)baseDurability * multiplier);
            cir.setReturnValue((Object)modifiedDurability);
        }
    }
}

