/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CustomHoeItem
extends PickaxeItem {
    public CustomHoeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        String quality;
        float baseSpeed = super.m_8102_(stack, state);
        switch (quality = stack.m_41784_().m_128461_("ForgingQuality")) {
            case "expert": {
                return baseSpeed * 1.15f;
            }
            case "perfect": {
                return baseSpeed * 1.25f;
            }
            case "poor": {
                return baseSpeed * 0.9f;
            }
        }
        return baseSpeed;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int durabilityLoss = 1;
        String quality = stack.m_41784_().m_128461_("ForgingQuality");
        Random random = new Random();
        switch (quality) {
            case "poor": {
                durabilityLoss = 2;
                break;
            }
            case "expert": {
                durabilityLoss = 1;
                break;
            }
            case "perfect": {
                durabilityLoss = random.nextFloat() < 0.25f ? 1 : 0;
                break;
            }
            default: {
                durabilityLoss = 1;
            }
        }
        stack.m_41622_(durabilityLoss, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            double extraDamage;
            String quality;
            switch (quality = stack.m_41784_().m_128461_("ForgingQuality")) {
                case "poor": {
                    double d = -1.0;
                    break;
                }
                case "expert": {
                    double d = 1.0;
                    break;
                }
                case "perfect": {
                    double d = 2.0;
                    break;
                }
                default: {
                    double d = extraDamage = 0.0;
                }
            }
            if (extraDamage != 0.0) {
                modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.randomUUID(), "forging_bonus", extraDamage, AttributeModifier.Operation.ADDITION));
            }
        }
        return modifiers;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        String quality = stack.m_41784_().m_128461_("ForgingQuality");
        if (!quality.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)this.getDisplayQuality(quality)).m_130940_(ChatFormatting.GRAY));
        }
    }

    private String getDisplayQuality(String key) {
        return switch (key) {
            case "poor" -> "Poorly Forged";
            case "well" -> "Well Forged";
            case "expert" -> "Expertly Forged";
            case "perfect" -> "Perfectly Forged";
            default -> "";
        };
    }

    public boolean m_6813_(ItemStack stack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        int durabilityLoss = 1;
        String quality = stack.m_41784_().m_128461_("ForgingQuality");
        Random random = new Random();
        switch (quality) {
            case "poor": {
                durabilityLoss = 2;
                break;
            }
            case "expert": {
                durabilityLoss = 1;
                break;
            }
            case "perfect": {
                durabilityLoss = random.nextFloat() < 0.25f ? 1 : 0;
            }
        }
        stack.m_41622_(durabilityLoss, pEntityLiving, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }
}

