/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.recipe.ForgingRecipe;

public class ForgingRecipeCategory
implements IRecipeCategory<ForgingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"forging");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/smithing_anvil_jei.png");
    public static final RecipeType<ForgingRecipe> FORGING_RECIPE_TYPE = new RecipeType(UID, ForgingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int imageWidth = 116;
    private static final int imageHeight = 54;

    public ForgingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 29, 16, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SMITHING_ANVIL.get()));
    }

    public RecipeType<ForgingRecipe> getRecipeType() {
        return FORGING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.overgeared.smithing_anvil.gui");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(ForgingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String hitsText = "Hits Need: " + recipe.getRemainingHits();
        int x = 58;
        int y = 27;
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, hitsText, 57, 1, 0x404040, false);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ForgingRecipe recipe, IFocusGroup focuses) {
        int width = recipe.width;
        int height = recipe.height;
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = y * width + x;
                Ingredient ingredient = (Ingredient)ingredients.get(index);
                builder.addSlot(RecipeIngredientRole.INPUT, 1 + x * 18, 1 + y * 18).addIngredients(ingredient);
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.m_8043_(null));
    }
}

