/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.AbstractWaterBarrel;
import net.stirdrem.overgeared.block.custom.WaterBarrel;
import net.stirdrem.overgeared.core.waterbarrel.BarrelInteraction;

public class LayeredWaterBarrel
extends AbstractWaterBarrel {
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 2;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)1, (int)2);
    private static final int BASE_CONTENT_HEIGHT = 6;
    private static final double HEIGHT_PER_LEVEL = 3.0;
    public static final Predicate<Biome.Precipitation> RAIN = precipitation -> precipitation == Biome.Precipitation.RAIN;
    public static final Predicate<Biome.Precipitation> SNOW = precipitation -> precipitation == Biome.Precipitation.SNOW;
    private final Predicate<Biome.Precipitation> fillPredicate;

    public LayeredWaterBarrel(BlockBehaviour.Properties pProperties, Predicate<Biome.Precipitation> pFillPredicate, Map<Item, BarrelInteraction> pInteractions) {
        super(pProperties, pInteractions);
        this.fillPredicate = pFillPredicate;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public boolean isFull(BlockState pState) {
        return (Integer)pState.m_61143_((Property)LEVEL) == 2;
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid pFluid) {
        return pFluid == Fluids.f_76193_ && this.fillPredicate == RAIN;
    }

    @Override
    protected double getContentHeight(BlockState pState) {
        return (6.0 + (double)((Integer)pState.m_61143_((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && pEntity.m_6060_() && this.isEntityInsideContent(pState, pPos, pEntity)) {
            pEntity.m_20095_();
            if (pEntity.m_142265_(pLevel, pPos)) {
                this.handleEntityOnFireInside(pState, pLevel, pPos);
            }
        }
    }

    protected void handleEntityOnFireInside(BlockState pState, Level pLevel, BlockPos pPos) {
        LayeredWaterBarrel.lowerFillLevel(pState, pLevel, pPos);
    }

    public static void lowerFillLevel(BlockState pState, Level pLevel, BlockPos pPos) {
        int i = (Integer)pState.m_61143_((Property)LEVEL) - 1;
        BlockState blockstate = i == 0 ? ((Block)ModBlocks.WATER_BARREL.get()).m_49966_() : (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(i));
        pLevel.m_46597_(pPos, blockstate);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
    }

    public static void emptyBarrel(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = ((Block)ModBlocks.WATER_BARREL.get()).m_49966_();
        pLevel.m_46597_(pPos, blockstate);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
    }

    public void m_141997_(BlockState pState, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        if (WaterBarrel.shouldHandlePrecipitation(pLevel, pPrecipitation) && (Integer)pState.m_61143_((Property)LEVEL) != 2 && this.fillPredicate.test(pPrecipitation)) {
            BlockState blockstate = (BlockState)pState.m_61122_((Property)LEVEL);
            pLevel.m_46597_(pPos, blockstate);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
        }
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.m_61143_((Property)LEVEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LEVEL});
    }

    @Override
    protected void receiveStalactiteDrip(BlockState pState, Level pLevel, BlockPos pPos, Fluid pFluid) {
        if (!this.isFull(pState)) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)LEVEL) + 1));
            pLevel.m_46597_(pPos, blockstate);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
            pLevel.m_46796_(1047, pPos, 0);
        }
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }
}

