/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared;

import cech12.bucketlib.api.BucketLibApi;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.core.waterbarrel.BarrelInteraction;
import net.stirdrem.overgeared.item.ModCreativeModeTabs;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.loot.ModLootModifiers;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;
import net.stirdrem.overgeared.screen.ModMenuTypes;
import net.stirdrem.overgeared.screen.SmithingAnvilScreen;
import net.stirdrem.overgeared.util.TickScheduler;
import org.slf4j.Logger;

@Mod(value="overgeared")
public class OvergearedMod {
    public static final String MOD_ID = "overgeared";
    public static final Logger LOGGER = LogUtils.getLogger();

    public OvergearedMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ServerConfig.loadConfig(ServerConfig.SERVER_CONFIG, FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("overgeared-server.toml"));
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        MinecraftForge.EVENT_BUS.register(TickScheduler.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModMessages.register();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.IRON_TONGS);
            event.accept(ModItems.STEEL_TONGS);
            event.accept(ModItems.SMITHING_HAMMER);
            event.m_246326_((ItemLike)ModItems.STEEL_PICKAXE.get());
            event.m_246326_((ItemLike)ModItems.STEEL_AXE.get());
            event.m_246326_((ItemLike)ModItems.STEEL_SHOVEL.get());
            event.m_246326_((ItemLike)ModItems.STEEL_HOE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.m_246326_((ItemLike)ModItems.STEEL_SWORD.get());
        }
    }

    private void sendImc(InterModEnqueueEvent evt) {
        BucketLibApi.registerBucket((ResourceLocation)ModItems.WOODEN_BUCKET.getId());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SMITHING_ANVIL_MENU.get()), SmithingAnvilScreen::new);
            BarrelInteraction.bootStrap();
        }
    }
}

