/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.api.crafting;

import cech12.bucketlib.BucketLib;
import cech12.bucketlib.util.BucketLibUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class FluidIngredient
extends Ingredient {
    protected final Fluid fluid;
    protected final TagKey<Fluid> tag;
    private ItemStack[] matchingStacks;

    private FluidIngredient(Fluid fluid, TagKey<Fluid> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.fluid = fluid;
        this.tag = tag;
    }

    public FluidIngredient(Fluid fluid) {
        this(fluid, null);
    }

    public FluidIngredient(TagKey<Fluid> tag) {
        this(null, tag);
    }

    private boolean isFluidCorrect(Fluid fluid) {
        return fluid != null && (this.fluid != null && fluid.m_6212_(this.fluid) || this.tag != null && fluid.m_76145_().m_205070_(this.tag));
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (location != null && "mekanism".equals(location.m_135827_()) && itemStack.getCraftingRemainingItem().m_41619_()) {
            return false;
        }
        ItemStack container = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
        Optional drainedFluidOptional = FluidUtil.getFluidHandler((ItemStack)container).map(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (drainedFluidOptional.isPresent() && !((FluidStack)drainedFluidOptional.get()).isEmpty()) {
            FluidStack drainedFluid = (FluidStack)drainedFluidOptional.get();
            return this.isFluidCorrect(drainedFluid.getFluid()) && drainedFluid.getAmount() == 1000;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Fluid> fluids = new ArrayList<Fluid>();
            ITagManager fluidTags = ForgeRegistries.FLUIDS.tags();
            if (this.tag != null && fluidTags != null) {
                fluidTags.getTag(this.tag).forEach(fluids::add);
            } else if (this.fluid != null) {
                fluids.add(this.fluid);
            }
            for (Fluid fluid : fluids) {
                BucketItem specificBucketItem;
                Item bucketItem = fluid.m_6859_();
                if (!(bucketItem instanceof BucketItem) || (specificBucketItem = (BucketItem)bucketItem).getFluid() != fluid) continue;
                stacks.add(new ItemStack((ItemLike)bucketItem));
            }
            for (Fluid fluid : fluids) {
                BucketLib.getRegisteredBuckets().forEach(universalBucketItem -> {
                    if (universalBucketItem.canHoldFluid(fluid)) {
                        stacks.add(BucketLibUtil.addFluid(new ItemStack((ItemLike)universalBucketItem), fluid));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Serializer.NAME.toString());
        if (this.fluid != null) {
            jsonObject.addProperty("fluid", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.fluid)).toString());
        }
        if (this.tag != null) {
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
        }
        return jsonObject;
    }

    public static final class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("bucketlib", "fluid");

        private Serializer() {
        }

        @Nonnull
        public FluidIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            String fluid = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new FluidIngredient((TagKey<Fluid>)tag);
            }
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a fluid ingredient with no fluid or tag.");
            }
            return new FluidIngredient((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)));
        }

        @Nonnull
        public FluidIngredient parse(@Nonnull JsonObject json) {
            if (json.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)tagId);
                return new FluidIngredient((TagKey<Fluid>)tag);
            }
            ResourceLocation fluid = new ResourceLocation(json.get("fluid").getAsString());
            if (!ForgeRegistries.FLUIDS.containsKey(fluid)) {
                throw new JsonSyntaxException("Unknown fluid: " + String.valueOf(fluid));
            }
            return new FluidIngredient((Fluid)ForgeRegistries.FLUIDS.getValue(fluid));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull FluidIngredient ingredient) {
            buffer.m_130070_(ingredient.fluid != null ? Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)ingredient.fluid)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    }
}

