/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.api.crafting;

import cech12.bucketlib.BucketLib;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class EmptyIngredient
extends Ingredient {
    protected Item item;
    protected TagKey<Item> tag;
    private ItemStack[] matchingStacks;

    public EmptyIngredient(Item item, TagKey<Item> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.item = item;
        this.tag = tag;
    }

    public EmptyIngredient(Item item) {
        this(item, null);
    }

    public EmptyIngredient(TagKey<Item> tag) {
        this(null, tag);
    }

    public EmptyIngredient() {
        this(null, null);
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (this.item == null && this.tag == null && itemStack.m_41720_() == Items.f_42446_) {
            return true;
        }
        if (this.item != null && itemStack.m_41720_() == this.item || this.tag != null && itemStack.m_204117_(this.tag) || this.item == null && this.tag == null && itemStack.m_41720_() instanceof UniversalBucketItem) {
            return BucketLibUtil.isEmpty(itemStack);
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (this.item == null && this.tag == null) {
                stacks.add(new ItemStack((ItemLike)Items.f_42446_));
            }
            BucketLib.getRegisteredBuckets().forEach(universalBucketItem -> {
                ItemStack universalBucketItemStack = new ItemStack((ItemLike)universalBucketItem);
                if (this.item != null && universalBucketItem == this.item || this.tag != null && universalBucketItemStack.m_204117_(this.tag) || this.item == null && this.tag == null) {
                    stacks.add(universalBucketItemStack);
                }
            });
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Serializer.NAME.toString());
        if (this.item != null) {
            jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.item)).toString());
        }
        if (this.tag != null) {
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
        }
        return jsonObject;
    }

    public static final class Serializer
    implements IIngredientSerializer<EmptyIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("bucketlib", "empty");

        private Serializer() {
        }

        @Nonnull
        public EmptyIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            String item = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!item.isEmpty()) {
                return new EmptyIngredient((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
            }
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new EmptyIngredient((TagKey<Item>)tag);
            }
            return new EmptyIngredient();
        }

        @Nonnull
        public EmptyIngredient parse(@Nonnull JsonObject json) {
            if (json.has("item")) {
                ResourceLocation item = new ResourceLocation(json.get("item").getAsString());
                if (!ForgeRegistries.ITEMS.containsKey(item)) {
                    throw new JsonSyntaxException("Unknown item: " + String.valueOf(item));
                }
                return new EmptyIngredient((Item)ForgeRegistries.ITEMS.getValue(item));
            }
            if (json.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)tagId);
                return new EmptyIngredient((TagKey<Item>)tag);
            }
            return new EmptyIngredient();
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull EmptyIngredient ingredient) {
            buffer.m_130070_(ingredient.item != null ? Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.item)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    }
}

