/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)RegistryUtil.class.getName());
    private static List<BucketBlock> bucketBlocks;
    private static List<BucketEntity> bucketEntities;

    private RegistryUtil() {
    }

    private static void readRegistry() {
        bucketBlocks = new ArrayList<BucketBlock>();
        bucketEntities = new ArrayList<BucketEntity>();
        Level level = RegistryUtil.getCurrentLevel();
        for (Item item : ForgeRegistries.ITEMS) {
            SolidBucketItem bucket;
            if (item instanceof SolidBucketItem) {
                bucket = (SolidBucketItem)item;
                if (bucketBlocks.stream().noneMatch(bucketBlock -> bucketBlock.block == bucket.m_40614_())) {
                    bucketBlocks.add(new BucketBlock(bucket.m_40614_(), bucket));
                }
            }
            if (!(item instanceof MobBucketItem)) continue;
            bucket = (MobBucketItem)item;
            try {
                Method method = MobBucketItem.class.getDeclaredMethod("getFishType", new Class[0]);
                method.setAccessible(true);
                EntityType entityType = (EntityType)method.invoke((Object)bucket, new Object[0]);
                if (entityType == null || level == null || !(entityType.m_20615_(level) instanceof Bucketable) || !bucketEntities.stream().noneMatch(bucketEntity -> bucketEntity.entityType == entityType)) continue;
                bucketEntities.add(new BucketEntity(entityType, bucket.getFluid(), (MobBucketItem)bucket));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.error("Failed to load MobBucketItem of " + String.valueOf(bucket), (Throwable)ex);
            }
        }
    }

    private static Level getCurrentLevel() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().m_129783_();
        }
        return ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElse(null);
    }

    public static List<BucketBlock> getBucketBlocks() {
        if (bucketBlocks == null) {
            RegistryUtil.readRegistry();
        }
        return bucketBlocks;
    }

    public static BucketBlock getBucketBlock(Block block) {
        for (BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
            if (bucketBlock.block() != block) continue;
            return bucketBlock;
        }
        return null;
    }

    public static List<BucketEntity> getBucketEntities() {
        if (bucketEntities == null) {
            RegistryUtil.readRegistry();
        }
        return bucketEntities;
    }

    public static BucketEntity getBucketEntity(EntityType<?> entityType) {
        for (BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
            if (bucketEntity.entityType() != entityType) continue;
            return bucketEntity;
        }
        return null;
    }

    public record BucketBlock(Block block, SolidBucketItem bucketItem) {
    }

    public record BucketEntity(EntityType<?> entityType, Fluid fluid, MobBucketItem bucketItem) {
    }
}

