/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.mixin;

import cech12.bucketlib.BucketLib;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxolotlAi.class})
public class AxolotlAiMixin {
    private static Ingredient axolotlTemptations = null;

    @Inject(at={@At(value="RETURN")}, method={"getTemptations"}, cancellable=true)
    private static void getTemptationsProxy(CallbackInfoReturnable<Ingredient> cir) {
        if (axolotlTemptations == null) {
            ArrayList<ItemStack> temptationStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : ((Ingredient)cir.getReturnValue()).m_43908_()) {
                temptationStacks.add(stack);
                Item item = stack.m_41720_();
                if (!(item instanceof MobBucketItem)) continue;
                MobBucketItem mobBucketItem = (MobBucketItem)item;
                Fluid fluid = mobBucketItem.getFluid();
                EntityType<?> entityType = BucketLibUtil.getEntityTypeOfMobBucketItem(mobBucketItem);
                for (UniversalBucketItem bucketItem : BucketLib.getRegisteredBuckets()) {
                    if (!bucketItem.canHoldFluid(fluid) || !bucketItem.canHoldEntity(entityType)) continue;
                    ItemStack bucket = new ItemStack((ItemLike)bucketItem);
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                    bucket = BucketLibUtil.addEntityType(bucket, entityType);
                    temptationStacks.add(bucket);
                }
            }
            axolotlTemptations = Ingredient.m_43921_(temptationStacks.stream());
        }
        cir.setReturnValue((Object)axolotlTemptations);
    }
}

