/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import com.google.common.collect.LinkedHashMultimap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.stirdrem.overgeared.client.AnvilMinigameOverlay;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.util.ModTags;

@Mod.EventBusSubscriber(modid="overgeared")
public class ModEvents {
    private static int TICK = 0;
    private static final int perTick = 30;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.m_5776_()) {
            return;
        }
        Level level = event.level;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ItemStack offhandStack;
            Player player = event.player;
            Level level = player.m_9236_();
            ++TICK;
            boolean hasHeatedIngot = false;
            if (level.m_5776_()) {
                return;
            }
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || !stack.m_204117_(ModTags.Items.HEATED_METALS)) continue;
                hasHeatedIngot = true;
                break;
            }
            if (!(offhandStack = player.m_21206_()).m_41619_() && offhandStack.m_204117_(ModTags.Items.HEATED_METALS)) {
                hasHeatedIngot = true;
            }
            if (hasHeatedIngot) {
                boolean hasTongs = false;
                ItemStack offhand = player.m_21206_();
                if (!offhand.m_41619_() && offhand.m_204117_(ModTags.Items.TONGS)) {
                    hasTongs = true;
                    if (level.m_46467_() % 40L == 0L) {
                        offhandStack.m_41622_(1, (LivingEntity)event.player, p -> p.m_21190_(player.m_7655_()));
                    }
                }
                if (!hasTongs) {
                    player.m_6469_(player.m_269291_().m_269047_(), 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AnvilMinigameOverlay.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            String quality = stack.m_41783_().m_128461_("ForgingQuality");
            Item item = stack.m_41720_();
            if (ModEvents.isWeapon(item)) {
                double damageBonus = ModEvents.getDamageBonusForQuality(quality);
                double speedBonus = ModEvents.getSpeedBonusForQuality(quality);
                ModEvents.modifyWeaponAttributes(event, damageBonus, speedBonus);
            }
            if (ModEvents.isArmor(item)) {
                double armorBonus = ModEvents.getArmorBonusForQuality(quality);
                ModEvents.modifyArmorAttribute(event, armorBonus);
            }
        }
    }

    private static boolean isWeapon(Item item) {
        return item instanceof SwordItem || item instanceof DiggerItem || item instanceof ProjectileWeaponItem;
    }

    private static boolean isArmor(Item item) {
        return item instanceof ArmorItem;
    }

    private static void modifyWeaponAttributes(ItemAttributeModifierEvent event, double damageBonus, double speedBonus) {
        AttributeModifier newModifier;
        LinkedHashMultimap originalModifiers = LinkedHashMultimap.create();
        originalModifiers.putAll(event.getOriginalModifiers());
        for (AttributeModifier modifier : originalModifiers.get((Object)Attributes.f_22281_)) {
            event.removeModifier(Attributes.f_22281_, modifier);
            newModifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_() + "_forged", modifier.m_22218_() + damageBonus, modifier.m_22217_());
            event.addModifier(Attributes.f_22281_, newModifier);
        }
        for (AttributeModifier modifier : originalModifiers.get((Object)Attributes.f_22283_)) {
            event.removeModifier(Attributes.f_22283_, modifier);
            newModifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_() + "_forged", modifier.m_22218_() + speedBonus, modifier.m_22217_());
            event.addModifier(Attributes.f_22283_, newModifier);
        }
    }

    private static void modifyArmorAttribute(ItemAttributeModifierEvent event, double damageBonus) {
        LinkedHashMultimap originalModifiers = LinkedHashMultimap.create();
        originalModifiers.putAll(event.getOriginalModifiers());
        for (AttributeModifier modifier : originalModifiers.get((Object)Attributes.f_22284_)) {
            event.removeModifier(Attributes.f_22284_, modifier);
            AttributeModifier newModifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_() + "_forged", modifier.m_22218_() + damageBonus, modifier.m_22217_());
            event.addModifier(Attributes.f_22284_, newModifier);
        }
    }

    private static double getDamageBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "perfect" -> (Double)ServerConfig.PERFECT_WEAPON_DAMAGE.get();
            case "expert" -> (Double)ServerConfig.EXPERT_WEAPON_DAMAGE.get();
            case "well" -> (Double)ServerConfig.WELL_WEAPON_DAMAGE.get();
            case "poor" -> (Double)ServerConfig.POOR_WEAPON_DAMAGE.get();
            default -> 0.0;
        };
    }

    private static double getSpeedBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "perfect" -> (Double)ServerConfig.PERFECT_WEAPON_SPEED.get();
            case "expert" -> (Double)ServerConfig.EXPERT_WEAPON_SPEED.get();
            case "well" -> (Double)ServerConfig.WELL_WEAPON_SPEED.get();
            case "poor" -> (Double)ServerConfig.POOR_WEAPON_SPEED.get();
            default -> 0.0;
        };
    }

    private static double getArmorBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "perfect" -> (Double)ServerConfig.PERFECT_ARMOR_BONUS.get();
            case "expert" -> (Double)ServerConfig.EXPERT_ARMOR_BONUS.get();
            case "well" -> (Double)ServerConfig.WELL_ARMOR_BONUS.get();
            case "poor" -> (Double)ServerConfig.POOR_ARMOR_BONUS.get();
            default -> 0.0;
        };
    }
}

