/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.loot.AddItemModifier;

public class ModGlobalLootModifiersProvider
extends GlobalLootModifierProvider {
    private static final ResourceLocation SIMPLE_DUNGEON = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/simple_dungeon");
    private static final ResourceLocation ABANDONED_MINESHAFT = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/abandoned_mineshaft");
    private static final ResourceLocation STRONGHOLD_CORRIDOR = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/stronghold_corridor");
    private static final ResourceLocation STRONGHOLD_CROSSING = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/stronghold_crossing");
    private static final ResourceLocation STRONGHOLD_LIBRARY = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/stronghold_library");
    private static final ResourceLocation DESERT_PIRAMID = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/desert_piramid");
    private static final ResourceLocation JUNGLE_TEMPLE = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/jungle_temple");
    private static final ResourceLocation SHIPWRECK_TREASURE = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/shipwreck_treasure");
    private static final ResourceLocation WOODLAND_MANSION = ResourceLocation.m_214293_((String)"minecraft", (String)"chests/woodland_mansion");

    public ModGlobalLootModifiersProvider(PackOutput output) {
        super(output, "overgeared");
    }

    protected void start() {
        ResourceLocation[] lessRareDungeon;
        ResourceLocation[] otherDungeons;
        for (ResourceLocation dungeon : otherDungeons = new ResourceLocation[]{STRONGHOLD_CORRIDOR, STRONGHOLD_CROSSING, STRONGHOLD_LIBRARY, DESERT_PIRAMID, SHIPWRECK_TREASURE, WOODLAND_MANSION, JUNGLE_TEMPLE}) {
            String namePrefix = dungeon.m_135815_().replace("chests/", "");
            this.add("steel_ingot_from_" + namePrefix, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(dungeon).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.75f).m_6409_()}, (Item)ModItems.STEEL_INGOT.get()));
            this.add("diamond_upgrade_from_" + namePrefix, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(dungeon).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.5f).m_6409_()}, (Item)ModItems.DIAMOND_UPGRADE_SMITHING_TEMPLATE.get()));
        }
        for (ResourceLocation dungeon : lessRareDungeon = new ResourceLocation[]{ABANDONED_MINESHAFT, SIMPLE_DUNGEON}) {
            String namePrefix = dungeon.m_135815_().replace("chests/", "");
            this.add("steel_ingot_from_" + namePrefix, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(dungeon).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.5f).m_6409_()}, (Item)ModItems.STEEL_INGOT.get()));
            this.add("steel_ingot_from_" + namePrefix + "_2", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(dungeon).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.35f).m_6409_()}, (Item)ModItems.STEEL_INGOT.get()));
            this.add("diamond_upgrade_from_" + namePrefix, (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(dungeon).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)0.35f).m_6409_()}, (Item)ModItems.DIAMOND_UPGRADE_SMITHING_TEMPLATE.get()));
        }
    }
}

