/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.block.custom.SmithingAnvil;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.client.AnvilMinigameOverlay;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.screen.SmithingAnvilMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingAnvilBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            SmithingAnvilBlockEntity.this.m_6596_();
            if (!SmithingAnvilBlockEntity.this.f_58857_.m_5776_()) {
                SmithingAnvilBlockEntity.this.f_58857_.m_7260_(SmithingAnvilBlockEntity.this.m_58899_(), SmithingAnvilBlockEntity.this.m_58900_(), SmithingAnvilBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 10;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> SmithingAnvilBlockEntity.this.progress;
                case 1 -> SmithingAnvilBlockEntity.this.maxProgress;
                case 2 -> SmithingAnvilBlockEntity.this.hitRemains;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    SmithingAnvilBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    SmithingAnvilBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 0;
    private int hitRemains;
    private long busyUntilGameTime = 0L;
    private ForgingRecipe lastRecipe = null;

    public SmithingAnvilBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SMITHING_ANVIL_BE.get(), pPos, pBlockState);
    }

    public ItemStack getRenderStack(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.overgeared.smithing_anvil");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.m_6047_()) {
            return new SmithingAnvilMenu(pContainerId, pPlayerInventory, this, this.data);
        }
        return null;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("smithing_anvil.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("smithing_anvil.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        if (this.hasRecipe()) {
            ForgingRecipe currentRecipe = recipe.get();
            this.maxProgress = currentRecipe.getHammeringRequired();
            this.increaseCraftingProgress();
            SmithingAnvilBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.lastRecipe = null;
        AnvilMinigameOverlay.endMinigame();
    }

    private void craftItem() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            ForgingRecipe recipe = recipeOptional.get();
            ItemStack result = recipe.m_8043_(this.m_58904_().m_9598_());
            String quality = this.determineForgingQuality();
            if (quality != null && !quality.isEmpty() && recipe.hasQuality()) {
                CompoundTag tag = result.m_41784_();
                tag.m_128359_("ForgingQuality", quality);
                result.m_41751_(tag);
            }
            for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
                this.itemHandler.extractItem(i, 1, false);
            }
            ItemStack existing = this.itemHandler.getStackInSlot(10);
            if (existing.m_41619_()) {
                this.itemHandler.setStackInSlot(10, result);
            } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)result)) {
                int maxSize;
                int total = existing.m_41613_() + result.m_41613_();
                if (total <= (maxSize = Math.min(existing.m_41741_(), this.itemHandler.getSlotLimit(10)))) {
                    existing.m_41769_(result.m_41613_());
                    this.itemHandler.setStackInSlot(10, existing);
                } else {
                    int remainder = total - maxSize;
                    existing.m_41764_(maxSize);
                    this.itemHandler.setStackInSlot(10, existing);
                    ItemStack overflow = result.m_41777_();
                    overflow.m_41764_(remainder);
                    Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)overflow);
                }
            }
        }
    }

    public boolean hasRecipe() {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack resultStack = recipe.get().m_8043_(this.f_58857_.m_9598_());
            return this.canInsertItemIntoOutputSlot(resultStack) && this.canInsertAmountIntoOutputSlot(resultStack.m_41613_());
        }
        return false;
    }

    private boolean hasEnoughIngredients(ForgingRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        SimpleContainer inventory = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        SimpleContainer inventoryCopy = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventoryCopy.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = inventoryCopy.m_8020_(i);
                if (!ingredient.test(stack) || stack.m_41613_() <= 0) continue;
                stack.m_41774_(1);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Optional<ForgingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return ForgingRecipe.findBestMatch(this.f_58857_, (Container)inventory).filter(this::matchesRecipeExactly);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack stackToInsert) {
        ItemStack existing = this.itemHandler.getStackInSlot(10);
        return existing.m_41619_() || ItemStack.m_150942_((ItemStack)existing, (ItemStack)stackToInsert);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(10).m_41613_() + count <= this.itemHandler.getStackInSlot(10).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    public boolean isBusy(long currentGameTime) {
        return currentGameTime < this.busyUntilGameTime;
    }

    public void setBusyUntil(long time) {
        this.busyUntilGameTime = time;
        SmithingAnvilBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
    }

    public void updateHitsRemaining(Level lvl, BlockPos pos, BlockState st) {
        Optional<ForgingRecipe> currentRecipeOpt = this.getCurrentRecipe();
        boolean recipeChanged = false;
        if (currentRecipeOpt.isPresent()) {
            ForgingRecipe currentRecipe = currentRecipeOpt.get();
            if (this.lastRecipe != null) {
                recipeChanged = !currentRecipe.m_6423_().equals((Object)this.lastRecipe.m_6423_());
            } else if (this.maxProgress > 0) {
                recipeChanged = true;
            }
            this.lastRecipe = currentRecipe;
        } else {
            recipeChanged = this.lastRecipe != null || this.maxProgress > 0;
            this.lastRecipe = null;
        }
        if (recipeChanged) {
            this.resetProgress();
            return;
        }
        if (this.hasRecipe()) {
            ForgingRecipe recipe = currentRecipeOpt.get();
            this.maxProgress = recipe.getHammeringRequired();
            this.hitRemains = this.maxProgress - this.progress;
            SmithingAnvilBlockEntity.m_155232_((Level)lvl, (BlockPos)pos, (BlockState)st);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    public int getHitsRemaining() {
        return this.hitRemains;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void applyForgingQuality(ItemStack stack, ForgingQuality quality) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("ForgingQuality", quality.getDisplayName());
    }

    private boolean matchesRecipeExactly(ForgingRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return recipe.m_5818_((Container)inventory, this.f_58857_);
    }

    private String determineForgingQuality() {
        String quality;
        switch (quality = SmithingAnvil.getQuality()) {
            case "poor": {
                return ForgingQuality.POOR.getDisplayName();
            }
            case "expert": {
                return ForgingQuality.EXPERT.getDisplayName();
            }
            case "perfect": {
                return ForgingQuality.PERFECT.getDisplayName();
            }
        }
        return ForgingQuality.WELL.getDisplayName();
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.m_6596_();
        if (this.data != null) {
            this.data.m_8050_(0, progress);
        }
    }

    public int getRequiredProgress() {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        ForgingRecipe currentRecipe = recipe.get();
        return currentRecipe.getHammeringRequired() - this.progress;
    }
}

