/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.AbstractWaterBarrel;
import net.stirdrem.overgeared.core.waterbarrel.BarrelInteraction;

public class WaterBarrel
extends AbstractWaterBarrel {
    private static final float RAIN_FILL_CHANCE = 0.05f;
    private static final float POWDER_SNOW_FILL_CHANCE = 0.1f;

    public WaterBarrel(BlockBehaviour.Properties properties) {
        super(properties, BarrelInteraction.EMPTY);
    }

    @Override
    public boolean isFull(BlockState pState) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(Level pLevel, Biome.Precipitation pPrecipitation) {
        if (pPrecipitation == Biome.Precipitation.RAIN) {
            return pLevel.m_213780_().m_188501_() < 0.05f;
        }
        if (pPrecipitation == Biome.Precipitation.SNOW) {
            return pLevel.m_213780_().m_188501_() < 0.1f;
        }
        return false;
    }

    public void m_141997_(BlockState pState, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        if (WaterBarrel.shouldHandlePrecipitation(pLevel, pPrecipitation) && pPrecipitation == Biome.Precipitation.RAIN) {
            pLevel.m_46597_(pPos, ((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_());
            pLevel.m_142346_((Entity)null, GameEvent.f_157792_, pPos);
        }
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid pFluid) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(BlockState pState, Level pLevel, BlockPos pPos, Fluid pFluid) {
        if (pFluid == Fluids.f_76193_) {
            BlockState blockstate = ((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_();
            pLevel.m_46597_(pPos, blockstate);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
            pLevel.m_46796_(1047, pPos, 0);
        }
    }
}

