/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.stirdrem.overgeared.block.custom.LayeredWaterBarrel;
import net.stirdrem.overgeared.block.custom.SmithingAnvil;
import net.stirdrem.overgeared.block.custom.WaterBarrel;
import net.stirdrem.overgeared.core.waterbarrel.BarrelInteraction;
import net.stirdrem.overgeared.item.ModItems;

public class ModBlocks {
    private BlockState defaultBlockState;
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"overgeared");
    public static final RegistryObject<Block> SMITHING_ANVIL = ModBlocks.registerBlock("smithing_anvil", () -> new SmithingAnvil(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_60955_()));
    public static final RegistryObject<Block> STEEL_BLOCK = ModBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> WATER_BARREL = ModBlocks.registerBlock("water_barrel", () -> new WaterBarrel(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60955_()));
    public static final RegistryObject<Block> WATER_BARREL_FULL = ModBlocks.registerBlock("water_barrel_full", () -> new LayeredWaterBarrel(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60955_(), LayeredCauldronBlock.f_153515_, BarrelInteraction.WATER));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public final BlockState defaultBlockState() {
        return this.defaultBlockState;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

