/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class ForgingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;
    private final int hammering;
    private final boolean hasQuality;
    private final boolean showNotification;
    public final int width;
    public final int height;

    public ForgingRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result, int hammering, boolean hasQuality, boolean showNotification, int width, int height) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
        this.hammering = hammering;
        this.hasQuality = hasQuality;
        this.showNotification = showNotification;
        this.width = width;
        this.height = height;
    }

    public boolean m_5818_(Container inv, Level world) {
        ForgingRecipe bestMatch = null;
        int bestPriority = -1;
        for (int y = 0; y <= 3 - this.height; ++y) {
            for (int x = 0; x <= 3 - this.width; ++x) {
                int currentPriority;
                if (!this.matchesPattern(inv, x, y) || !this.checkSurroundingBlanks(inv, x, y) || (currentPriority = this.calculatePriority()) <= bestPriority) continue;
                bestPriority = currentPriority;
                bestMatch = this;
            }
        }
        return bestMatch == this;
    }

    private boolean checkSurroundingBlanks(Container inv, int xOffset, int yOffset) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int invSlot;
                if (x >= xOffset && x < xOffset + this.width && y >= yOffset && y < yOffset + this.height || inv.m_8020_(invSlot = y * 3 + x).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    private int calculatePriority() {
        int itemCount = 0;
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.m_43947_()) continue;
            ++itemCount;
        }
        return this.width * this.height * 100 + itemCount;
    }

    private boolean matchesPattern(Container inv, int xOffset, int yOffset) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int invSlot = (y + yOffset) * 3 + (x + xOffset);
                Ingredient ingredient = (Ingredient)this.ingredients.get(y * this.width + x);
                if (!(ingredient.m_43947_() ? !inv.m_8020_(invSlot).m_41619_() : !ingredient.test(inv.m_8020_(invSlot)))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.FORGING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FORGING.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ForgingRecipe that = (ForgingRecipe)obj;
        return this.m_6423_().equals((Object)that.m_6423_());
    }

    public int hashCode() {
        return Objects.hash(this.m_6423_());
    }

    public int getHammeringRequired() {
        return this.hammering;
    }

    public boolean hasQuality() {
        return this.hasQuality;
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public int getRemainingHits() {
        return this.hammering;
    }

    public static Optional<ForgingRecipe> findBestMatch(Level world, Container inv) {
        return world.m_7465_().m_44013_((RecipeType)ModRecipeTypes.FORGING.get()).stream().filter(recipe -> recipe.m_5818_(inv, world)).max(Comparator.comparingInt(ForgingRecipe::getRecipeSize));
    }

    private int getRecipeSize() {
        return this.width * this.height;
    }

    public static class Serializer
    implements RecipeSerializer<ForgingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"overgeared", (String)"forging");

        public ForgingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            int hammering = GsonHelper.m_13824_((JsonObject)json, (String)"hammering", (int)1);
            boolean hasQuality = GsonHelper.m_13855_((JsonObject)json, (String)"has_quality", (boolean)true);
            boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            Map<Character, Ingredient> keyMap = Serializer.parseKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            JsonArray pattern = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
            int width = pattern.get(0).getAsString().length();
            int height = pattern.size();
            NonNullList<Ingredient> ingredients = Serializer.dissolvePattern(pattern, keyMap, width, height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ForgingRecipe(recipeId, group, ingredients, result, hammering, hasQuality, showNotification, width, height);
        }

        private static Map<Character, Ingredient> parseKey(JsonObject keyJson) {
            HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
            for (Map.Entry entry : keyJson.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is not a single character");
                }
                keyMap.put(Character.valueOf(((String)entry.getKey()).charAt(0)), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            return keyMap;
        }

        private static NonNullList<Ingredient> dissolvePattern(JsonArray pattern, Map<Character, Ingredient> keys, int width, int height) {
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int y = 0; y < height; ++y) {
                String row = GsonHelper.m_13805_((JsonElement)pattern.get(y), (String)("pattern[" + y + "]"));
                if (row.length() != width) {
                    throw new JsonSyntaxException("Pattern row width mismatch");
                }
                for (int x = 0; x < width; ++x) {
                    char c = row.charAt(x);
                    Ingredient ingredient = keys.getOrDefault(Character.valueOf(c), (Ingredient)(c == ' ' ? Ingredient.f_43901_ : null));
                    if (ingredient == null) {
                        throw new JsonSyntaxException("Pattern references undefined symbol: '" + c + "'");
                    }
                    ingredients.set(y * width + x, (Object)ingredient);
                }
            }
            return ingredients;
        }

        public ForgingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int hammering = buffer.m_130242_();
            boolean hasQuality = buffer.readBoolean();
            boolean showNotification = buffer.readBoolean();
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new ForgingRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, result, hammering, hasQuality, showNotification, width, height);
        }

        public void toNetwork(FriendlyByteBuf buffer, ForgingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.hammering);
            buffer.writeBoolean(recipe.showNotification);
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }

    public static class Type
    implements RecipeType<ForgingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "forging";
    }
}

