/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.LayeredWaterBarrel;
import net.stirdrem.overgeared.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class HeatedItem
extends Item {
    public HeatedItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IntegerProperty levelProperty;
        int waterLevel;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack heldStack = context.m_43722_();
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_152476_)) {
            IntegerProperty levelProperty2 = LayeredCauldronBlock.f_153514_;
            int waterLevel2 = (Integer)state.m_61143_((Property)levelProperty2);
            if (waterLevel2 > 0 && heldStack.m_204117_(ModTags.Items.HEATED_METALS)) {
                if (waterLevel2 == 1) {
                    level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)levelProperty2, (Comparable)Integer.valueOf(waterLevel2 - 1)));
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                Item cooledItem = this.getCooledIngot(heldStack.m_41720_());
                if (cooledItem != null) {
                    ItemStack cooledIngot = new ItemStack((ItemLike)cooledItem);
                    heldStack.m_41774_(1);
                    if (heldStack.m_41619_()) {
                        player.m_21008_(context.m_43724_(), cooledIngot);
                    } else if (!player.m_150109_().m_36054_(cooledIngot)) {
                        player.m_36176_(cooledIngot, false);
                    }
                    if (player != null) {
                        player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (state.m_60713_((Block)ModBlocks.WATER_BARREL_FULL.get()) && (waterLevel = ((Integer)state.m_61143_((Property)(levelProperty = LayeredWaterBarrel.LEVEL))).intValue()) > 0 && heldStack.m_204117_(ModTags.Items.HEATED_METALS)) {
            if (waterLevel == 1) {
                level.m_46597_(pos, ((Block)ModBlocks.WATER_BARREL.get()).m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)levelProperty, (Comparable)Integer.valueOf(waterLevel - 1)));
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            Item cooledItem = this.getCooledIngot(heldStack.m_41720_());
            if (cooledItem != null) {
                ItemStack cooledIngot = new ItemStack((ItemLike)cooledItem);
                heldStack.m_41774_(1);
                if (heldStack.m_41619_()) {
                    player.m_21008_(context.m_43724_(), cooledIngot);
                } else if (!player.m_150109_().m_36054_(cooledIngot)) {
                    player.m_36176_(cooledIngot, false);
                }
                if (player != null) {
                    player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private Item getCooledIngot(Item heatedItem) {
        ITag heatedTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATED_METALS);
        ITag cooledTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATABLE_METALS);
        int index = 0;
        for (Item item : heatedTag) {
            if (item == heatedItem) {
                int i = 0;
                for (Item cooledItem : cooledTag) {
                    if (i == index) {
                        return cooledItem;
                    }
                    ++i;
                }
            }
            ++index;
        }
        return null;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        String quality = pStack.m_41784_().m_128461_("ForgingQuality");
        if (!quality.isEmpty()) {
            pTooltipComponents.add((Component)Component.m_237113_((String)this.getDisplayQuality(quality)).m_130940_(ChatFormatting.GRAY));
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.overgeared.heatedingots.tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()));
    }

    public int m_142159_(ItemStack stack) {
        float durabilityRatio = 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_();
        float hue = 0.05f * durabilityRatio;
        return 0xFF000000 | Color.HSBtoRGB(hue, 1.0f, 1.0f);
    }

    private String getDisplayQuality(String key) {
        return switch (key) {
            case "poor" -> "Poorly Forged";
            case "well" -> "Well Forged";
            case "expert" -> "Expertly Forged";
            case "perfect" -> "Perfectly Forged";
            default -> "";
        };
    }
}

