/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.LayeredWaterBarrel;
import net.stirdrem.overgeared.util.ModTags;

@Mod.EventBusSubscriber(modid="overgeared")
public class ModItemInteractEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        BlockState state = level.m_8055_(pos);
        if (!heldStack.m_204117_(ModTags.Items.HEATED_METALS)) {
            return;
        }
        if (state.m_60713_(Blocks.f_152476_)) {
            ModItemInteractEvents.handleCauldronInteraction(level, pos, player, heldStack, state);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        } else if (state.m_60713_((Block)ModBlocks.WATER_BARREL_FULL.get())) {
            ModItemInteractEvents.handleWaterBarrelInteraction(level, pos, player, heldStack, state);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static void handleCauldronInteraction(Level level, BlockPos pos, Player player, ItemStack heldStack, BlockState state) {
        IntegerProperty levelProperty = LayeredCauldronBlock.f_153514_;
        int waterLevel = (Integer)state.m_61143_((Property)levelProperty);
        if (waterLevel > 0) {
            if (waterLevel == 1) {
                level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)levelProperty, (Comparable)Integer.valueOf(waterLevel - 1)));
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            ModItemInteractEvents.coolIngot(player, heldStack);
        }
    }

    private static void handleWaterBarrelInteraction(Level level, BlockPos pos, Player player, ItemStack heldStack, BlockState state) {
        IntegerProperty levelProperty = LayeredWaterBarrel.LEVEL;
        int waterLevel = (Integer)state.m_61143_((Property)levelProperty);
        if (waterLevel > 0) {
            if (waterLevel == 1) {
                level.m_46597_(pos, ((Block)ModBlocks.WATER_BARREL.get()).m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)levelProperty, (Comparable)Integer.valueOf(waterLevel - 1)));
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            ModItemInteractEvents.coolIngot(player, heldStack);
        }
    }

    private static void coolIngot(Player player, ItemStack heldStack) {
        Item cooledItem = ModItemInteractEvents.getCooledIngot(heldStack.m_41720_());
        if (cooledItem != null) {
            ItemStack cooledIngot = new ItemStack((ItemLike)cooledItem);
            heldStack.m_41774_(1);
            if (heldStack.m_41619_()) {
                player.m_21008_(player.m_7655_(), cooledIngot);
            } else if (!player.m_150109_().m_36054_(cooledIngot)) {
                player.m_36176_(cooledIngot, false);
            }
            if (player != null) {
                player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
        }
    }

    private static Item getCooledIngot(Item heatedItem) {
        ITag heatedTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATED_METALS);
        ITag cooledTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATABLE_METALS);
        int index = 0;
        for (Item item : heatedTag) {
            if (item == heatedItem) {
                int i = 0;
                for (Item cooledItem : cooledTag) {
                    if (i == index) {
                        return cooledItem;
                    }
                    ++i;
                }
            }
            ++index;
        }
        return null;
    }
}

