/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.recipe.ForgingRecipe;

public class ShapedForgingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final int hammering;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private Boolean hasQuality;
    @Nullable
    private String group;
    private boolean showNotification = true;

    public ShapedForgingRecipeBuilder(RecipeCategory category, ItemLike result, int count, int hammering) {
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
        this.hammering = hammering;
    }

    public static ShapedForgingRecipeBuilder shaped(RecipeCategory category, ItemLike result, int hammering) {
        return new ShapedForgingRecipeBuilder(category, result, 1, hammering);
    }

    public static ShapedForgingRecipeBuilder shaped(RecipeCategory category, ItemLike result, int count, int hammering) {
        return new ShapedForgingRecipeBuilder(category, result, count, hammering);
    }

    public ShapedForgingRecipeBuilder define(Character pSymbol, TagKey<Item> pTag) {
        return this.define(pSymbol, Ingredient.m_204132_(pTag));
    }

    public ShapedForgingRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedForgingRecipeBuilder define(Character pSymbol, Ingredient pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public ShapedForgingRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ShapedForgingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public ShapedForgingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedForgingRecipeBuilder setQuality(@Nullable boolean hasQuality) {
        this.hasQuality = hasQuality;
        return this;
    }

    public ShapedForgingRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pRecipeOutput, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        int width = this.rows.get(0).length();
        int height = this.rows.size();
        NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        for (int i = 0; i < height; ++i) {
            String patternLine = this.rows.get(i);
            for (int j = 0; j < width; ++j) {
                char symbol = patternLine.charAt(j);
                Ingredient ingredient = this.key.getOrDefault(Character.valueOf(symbol), Ingredient.f_43901_);
                ingredients.set(i * width + j, (Object)ingredient);
            }
        }
        pRecipeOutput.accept(new Result((NonNullList<Ingredient>)ingredients, this.hammering, new ItemStack((ItemLike)this.result, this.count), pRecipeId, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification, this.hasQuality == null ? true : this.hasQuality));
    }

    private void ensureValid(ResourceLocation pRecipeId) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped forging recipe " + pRecipeId + "!");
        }
        int width = this.rows.get(0).length();
        for (String row : this.rows) {
            if (row.length() == width) continue;
            throw new IllegalStateException("Pattern must be the same width on every line!");
        }
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final NonNullList<Ingredient> ingredients;
        private final int hammering;
        private final ItemStack result;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;
        private final String group;
        private final Boolean hasQuality;

        public Result(NonNullList<Ingredient> ingredients, int hammering, ItemStack result, ResourceLocation id, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation advancementId, boolean showNotification, Boolean hasQuality) {
            this.ingredients = ingredients;
            this.hammering = hammering;
            this.result = result;
            this.id = id;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.showNotification = showNotification;
            this.hasQuality = hasQuality;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            json.add("pattern", (JsonElement)patternArray);
            JsonObject jsonobject = new JsonObject();
            json.addProperty("hammering", (Number)this.hammering);
            if (this.hasQuality != null || this.hasQuality.booleanValue()) {
                json.addProperty("has_quality", this.hasQuality);
            }
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ForgingRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

