/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.core.waterbarrel;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.LayeredWaterBarrel;
import net.stirdrem.overgeared.item.ModItems;

public interface BarrelInteraction {
    public static final Map<Item, BarrelInteraction> EMPTY = BarrelInteraction.newInteractionMap();
    public static final Map<Item, BarrelInteraction> WATER = BarrelInteraction.newInteractionMap();
    public static final Map<Item, BarrelInteraction> LAVA = BarrelInteraction.newInteractionMap();
    public static final Map<Item, BarrelInteraction> POWDER_SNOW = BarrelInteraction.newInteractionMap();
    public static final BarrelInteraction FILL_WATER = (p_175683_, p_175684_, p_175685_, p_175686_, p_175687_, p_175688_) -> BarrelInteraction.emptyBucket(p_175684_, p_175685_, p_175686_, p_175687_, p_175688_, (BlockState)((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_().m_61124_((Property)LayeredWaterBarrel.LEVEL, (Comparable)Integer.valueOf(2)), SoundEvents.f_11778_);
    public static final BarrelInteraction SHULKER_BOX = (p_175662_, p_175663_, p_175664_, p_175665_, p_175666_, p_175667_) -> {
        Block block = Block.m_49814_((Item)p_175667_.m_41720_());
        if (!(block instanceof ShulkerBoxBlock)) {
            return InteractionResult.PASS;
        }
        if (!p_175663_.f_46443_) {
            ItemStack itemstack = new ItemStack((ItemLike)Blocks.f_50456_);
            if (p_175667_.m_41782_()) {
                itemstack.m_41751_(p_175667_.m_41783_().m_6426_());
            }
            p_175665_.m_21008_(p_175666_, itemstack);
            p_175665_.m_36220_(Stats.f_12947_);
            LayeredWaterBarrel.lowerFillLevel(p_175662_, p_175663_, p_175664_);
        }
        return InteractionResult.m_19078_((boolean)p_175663_.f_46443_);
    };
    public static final BarrelInteraction BANNER = (p_278890_, p_278891_, p_278892_, p_278893_, p_278894_, p_278895_) -> {
        if (BannerBlockEntity.m_58504_((ItemStack)p_278895_) <= 0) {
            return InteractionResult.PASS;
        }
        if (!p_278891_.f_46443_) {
            ItemStack itemstack = p_278895_.m_255036_(1);
            BannerBlockEntity.m_58509_((ItemStack)itemstack);
            if (!p_278893_.m_150110_().f_35937_) {
                p_278895_.m_41774_(1);
            }
            if (p_278895_.m_41619_()) {
                p_278893_.m_21008_(p_278894_, itemstack);
            } else if (p_278893_.m_150109_().m_36054_(itemstack)) {
                p_278893_.f_36095_.m_150429_();
            } else {
                p_278893_.m_36176_(itemstack, false);
            }
            p_278893_.m_36220_(Stats.f_12946_);
            LayeredWaterBarrel.lowerFillLevel(p_278890_, p_278891_, p_278892_);
        }
        return InteractionResult.m_19078_((boolean)p_278891_.f_46443_);
    };
    public static final BarrelInteraction DYED_ITEM = (p_175629_, p_175630_, p_175631_, p_175632_, p_175633_, p_175634_) -> {
        Item item = p_175634_.m_41720_();
        if (!(item instanceof DyeableLeatherItem)) {
            return InteractionResult.PASS;
        }
        DyeableLeatherItem dyeableleatheritem = (DyeableLeatherItem)item;
        if (!dyeableleatheritem.m_41113_(p_175634_)) {
            return InteractionResult.PASS;
        }
        if (!p_175630_.f_46443_) {
            dyeableleatheritem.m_41123_(p_175634_);
            p_175632_.m_36220_(Stats.f_12945_);
            LayeredWaterBarrel.lowerFillLevel(p_175629_, p_175630_, p_175631_);
        }
        return InteractionResult.m_19078_((boolean)p_175630_.f_46443_);
    };
    public static final BarrelInteraction FLUID_ITEM = (blockState, level, pos, player, hand, stack) -> {
        FluidStack drained;
        LazyOptional fluidHandlerLazy = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!fluidHandlerLazy.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidHandlerLazy.orElse(null);
        int simulatedFill = fluidHandlerItem.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.SIMULATE);
        if (simulatedFill > 0 && level.m_8055_(pos) == ((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_().m_61124_((Property)LayeredWaterBarrel.LEVEL, (Comparable)Integer.valueOf(2))) {
            int filled = fluidHandlerItem.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                level.m_46597_(pos, ((Block)ModBlocks.WATER_BARREL.get()).m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21008_(hand, fluidHandlerItem.getContainer());
                player.m_36220_(Stats.f_12944_);
                level.m_142346_(null, GameEvent.f_157816_, pos);
            }
        } else if (level.m_8055_(pos) != ((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_().m_61124_((Property)LayeredWaterBarrel.LEVEL, (Comparable)Integer.valueOf(2)) && !(drained = fluidHandlerItem.drain(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
            level.m_46597_(pos, (BlockState)((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_().m_61124_((Property)LayeredWaterBarrel.LEVEL, (Comparable)Integer.valueOf(2)));
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.m_21008_(hand, fluidHandlerItem.getContainer());
            player.m_36220_(Stats.f_12943_);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public static Object2ObjectOpenHashMap<Item, BarrelInteraction> newInteractionMap() {
        return (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), p_175646_ -> p_175646_.defaultReturnValue((p_175739_, p_175740_, p_175741_, p_175742_, p_175743_, p_175744_) -> InteractionResult.PASS));
    }

    public InteractionResult interact(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, ItemStack var6);

    public static void bootStrap() {
        BarrelInteraction.addDefaultInteractions(EMPTY);
        EMPTY.put(Items.f_42589_, (blockState, level, blockPos, player, hand, stack) -> {
            if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                level.m_46597_(blockPos, ((Block)ModBlocks.WATER_BARREL_FULL.get()).m_49966_());
                level.m_5594_((Player)null, blockPos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)null, GameEvent.f_157769_, blockPos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        BarrelInteraction.addDefaultInteractions(WATER);
        WATER.put(Items.f_42446_, (p_175725_, p_175726_, p_175727_, p_175728_, p_175729_, p_175730_) -> BarrelInteraction.fillBucket(p_175725_, p_175726_, p_175727_, p_175728_, p_175729_, p_175730_, new ItemStack((ItemLike)Items.f_42447_), p_175660_ -> (Integer)p_175660_.m_61143_((Property)LayeredWaterBarrel.LEVEL) == 2, SoundEvents.f_11781_));
        WATER.put(Items.f_42590_, (p_175718_, p_175719_, p_175720_, p_175721_, p_175722_, p_175723_) -> {
            if (!p_175719_.f_46443_) {
                Item item = p_175723_.m_41720_();
                p_175721_.m_21008_(p_175722_, ItemUtils.m_41813_((ItemStack)p_175723_, (Player)p_175721_, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                p_175721_.m_36220_(Stats.f_12944_);
                p_175721_.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredWaterBarrel.lowerFillLevel(p_175718_, p_175719_, p_175720_);
                p_175719_.m_5594_((Player)null, p_175720_, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                p_175719_.m_142346_((Entity)null, GameEvent.f_157816_, p_175720_);
            }
            return InteractionResult.m_19078_((boolean)p_175719_.f_46443_);
        });
        WATER.put(Items.f_42589_, (p_175704_, p_175705_, p_175706_, p_175707_, p_175708_, p_175709_) -> {
            if ((Integer)p_175704_.m_61143_((Property)LayeredWaterBarrel.LEVEL) != 2 && PotionUtils.m_43579_((ItemStack)p_175709_) == Potions.f_43599_) {
                if (!p_175705_.f_46443_) {
                    p_175707_.m_21008_(p_175708_, ItemUtils.m_41813_((ItemStack)p_175709_, (Player)p_175707_, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    p_175707_.m_36220_(Stats.f_12944_);
                    p_175707_.m_36246_(Stats.f_12982_.m_12902_((Object)p_175709_.m_41720_()));
                    p_175705_.m_46597_(p_175706_, (BlockState)p_175704_.m_61122_((Property)LayeredWaterBarrel.LEVEL));
                    p_175705_.m_5594_((Player)null, p_175706_, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    p_175705_.m_142346_((Entity)null, GameEvent.f_157769_, p_175706_);
                }
                return InteractionResult.m_19078_((boolean)p_175705_.f_46443_);
            }
            return InteractionResult.PASS;
        });
        WATER.put(Items.f_42463_, DYED_ITEM);
        WATER.put(Items.f_42462_, DYED_ITEM);
        WATER.put(Items.f_42408_, DYED_ITEM);
        WATER.put(Items.f_42407_, DYED_ITEM);
        WATER.put(Items.f_42654_, DYED_ITEM);
        WATER.put(Items.f_42660_, BANNER);
        WATER.put(Items.f_42667_, BANNER);
        WATER.put(Items.f_42728_, BANNER);
        WATER.put(Items.f_42671_, BANNER);
        WATER.put(Items.f_42672_, BANNER);
        WATER.put(Items.f_42669_, BANNER);
        WATER.put(Items.f_42673_, BANNER);
        WATER.put(Items.f_42663_, BANNER);
        WATER.put(Items.f_42668_, BANNER);
        WATER.put(Items.f_42665_, BANNER);
        WATER.put(Items.f_42662_, BANNER);
        WATER.put(Items.f_42661_, BANNER);
        WATER.put(Items.f_42666_, BANNER);
        WATER.put(Items.f_42670_, BANNER);
        WATER.put(Items.f_42727_, BANNER);
        WATER.put(Items.f_42664_, BANNER);
        WATER.put(Items.f_42266_, SHULKER_BOX);
        WATER.put(Items.f_42273_, SHULKER_BOX);
        WATER.put(Items.f_42229_, SHULKER_BOX);
        WATER.put(Items.f_42225_, SHULKER_BOX);
        WATER.put(Items.f_42226_, SHULKER_BOX);
        WATER.put(Items.f_42275_, SHULKER_BOX);
        WATER.put(Items.f_42227_, SHULKER_BOX);
        WATER.put(Items.f_42269_, SHULKER_BOX);
        WATER.put(Items.f_42274_, SHULKER_BOX);
        WATER.put(Items.f_42271_, SHULKER_BOX);
        WATER.put(Items.f_42268_, SHULKER_BOX);
        WATER.put(Items.f_42267_, SHULKER_BOX);
        WATER.put(Items.f_42272_, SHULKER_BOX);
        WATER.put(Items.f_42224_, SHULKER_BOX);
        WATER.put(Items.f_42228_, SHULKER_BOX);
        WATER.put(Items.f_42270_, SHULKER_BOX);
        WATER.put((Item)ModItems.WOODEN_BUCKET.get(), FLUID_ITEM);
        EMPTY.put((Item)ModItems.WOODEN_BUCKET.get(), FLUID_ITEM);
        BarrelInteraction.addDefaultInteractions(LAVA);
        BarrelInteraction.addDefaultInteractions(POWDER_SNOW);
    }

    public static void addDefaultInteractions(Map<Item, BarrelInteraction> pInteractionsMap) {
        pInteractionsMap.put(Items.f_42447_, FILL_WATER);
    }

    public static InteractionResult fillBucket(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pEmptyStack, ItemStack pFilledStack, Predicate<BlockState> pStatePredicate, SoundEvent pFillSound) {
        if (!pStatePredicate.test(pBlockState)) {
            return InteractionResult.PASS;
        }
        if (!pLevel.f_46443_) {
            Item item = pEmptyStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pEmptyStack, (Player)pPlayer, (ItemStack)pFilledStack));
            pPlayer.m_36220_(Stats.f_12944_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, ((Block)ModBlocks.WATER_BARREL.get()).m_49966_());
            pLevel.m_5594_((Player)null, pPos, pFillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_((Entity)null, GameEvent.f_157816_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public static InteractionResult emptyBucket(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pFilledStack, BlockState pState, SoundEvent pEmptySound) {
        if (!pLevel.f_46443_) {
            Item item = pFilledStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pFilledStack, (Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            pPlayer.m_36220_(Stats.f_12943_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, pState);
            pLevel.m_5594_((Player)null, pPos, pEmptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_((Entity)null, GameEvent.f_157769_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }
}

