/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.config.ServerConfig;

public class AnvilMinigameOverlay {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/smithing_anvil_minigame.png");
    public static boolean isVisible = false;
    private static ItemStack resultItem;
    private static int hitsRemaining;
    private static float arrowPosition;
    private static float arrowSpeed;
    private static float speedIncreasePerHit;
    private static boolean movingRight;
    private static int perfectHits;
    private static int goodHits;
    private static int missedHits;
    private static final int PERFECT_ZONE_START;
    private static final int PERFECT_ZONE_END;
    private static final int GOOD_ZONE_START;
    private static final int GOOD_ZONE_END;
    private static final int INITIAL_PERFECT_ZONE_SIZE = 20;
    private static final int INITIAL_GOOD_ZONE_SIZE = 40;
    private static int perfectZoneStart;
    private static int perfectZoneEnd;
    private static int goodZoneStart;
    private static int goodZoneEnd;
    private static float zoneShrinkFactor;
    private static float zoneShiftAmount;
    public static boolean temporaryExit;
    public static boolean minigameStarted;
    public static final int barTotalWidth = 184;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 20;
    private static final float BASE_SPEED = 2.0f;
    private static final float SPEED_INCREASE_PER_HIT = 0.75f;
    private static final float MAX_SPEED = 5.0f;
    public static final IGuiOverlay ANVIL_MG;

    public static void startMinigame(ItemStack result, int requiredHits) {
        if (minigameStarted) {
            AnvilMinigameOverlay.pauseMinigame();
            return;
        }
        if (result == null) {
            OvergearedMod.LOGGER.error("Attempted to start minigame with null result!");
            return;
        }
        minigameStarted = true;
        temporaryExit = false;
        isVisible = true;
        resultItem = result.m_41777_();
        hitsRemaining = requiredHits;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 0.0f;
        double as = (Double)ServerConfig.DEFAULT_ARROW_SPEED.get();
        arrowSpeed = (float)as;
        as = (Double)ServerConfig.DEFAULT_ARROW_SPEED_INCREASE.get();
        speedIncreasePerHit = (float)as;
        as = (Double)ServerConfig.ZONE_SHRINK_FACTOR.get();
        zoneShrinkFactor = (float)as;
        movingRight = true;
        double random = Math.random() * 10.0;
        perfectZoneStart = Math.max(0, Math.min(100, (int)((double)PERFECT_ZONE_START + random)));
        perfectZoneEnd = Math.max(0, Math.min(100, (int)((double)PERFECT_ZONE_END + random)));
        goodZoneStart = Math.max(0, Math.min(100, (int)((double)GOOD_ZONE_START + random)));
        goodZoneEnd = Math.max(0, Math.min(100, (int)((double)GOOD_ZONE_END + random)));
    }

    public static void tick() {
        if (!isVisible) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (movingRight) {
            if ((arrowPosition += arrowSpeed) >= 100.0f) {
                arrowPosition = 100.0f;
                movingRight = false;
            }
        } else if ((arrowPosition -= arrowSpeed) <= 0.0f) {
            arrowPosition = 0.0f;
            movingRight = true;
        }
    }

    public static String handleHit() {
        arrowSpeed = Math.min(arrowSpeed + speedIncreasePerHit, 5.0f);
        if (arrowPosition >= (float)perfectZoneStart && arrowPosition <= (float)perfectZoneEnd) {
            ++perfectHits;
        } else if (arrowPosition >= (float)goodZoneStart && arrowPosition <= (float)goodZoneEnd) {
            ++goodHits;
        } else {
            ++missedHits;
        }
        AnvilMinigameOverlay.shrinkAndShiftZones();
        if (--hitsRemaining <= 0) {
            return AnvilMinigameOverlay.finishForging();
        }
        return null;
    }

    private static void shrinkAndShiftZones() {
        float perfectZoneSize = perfectZoneEnd - perfectZoneStart;
        float goodZoneSize = goodZoneEnd - goodZoneStart;
        perfectZoneSize *= zoneShrinkFactor;
        goodZoneSize *= zoneShrinkFactor;
        perfectZoneSize = Math.max(perfectZoneSize, 5.0f);
        goodZoneSize = Math.max(goodZoneSize, perfectZoneSize * 2.0f);
        float random = (float)Math.random();
        float perfectZoneCenter = (float)(perfectZoneStart + perfectZoneEnd) / 2.0f;
        perfectZoneCenter += (float)((double)random - 0.5) * zoneShiftAmount * 3.0f;
        perfectZoneCenter = Math.max(20.0f, Math.min(80.0f, perfectZoneCenter));
        float goodZoneCenter = (float)(goodZoneStart + goodZoneEnd) / 2.0f;
        goodZoneCenter += (float)((double)random - 0.5) * zoneShiftAmount * 3.0f;
        goodZoneCenter = Math.max(20.0f, Math.min(80.0f, goodZoneCenter));
        perfectZoneStart = (int)(perfectZoneCenter - perfectZoneSize / 2.0f);
        perfectZoneEnd = (int)(perfectZoneCenter + perfectZoneSize / 2.0f);
        goodZoneStart = (int)(goodZoneCenter - goodZoneSize / 2.0f);
        goodZoneEnd = (int)(goodZoneCenter + goodZoneSize / 2.0f);
        perfectZoneStart = Math.max(0, perfectZoneStart);
        perfectZoneEnd = Math.min(100, perfectZoneEnd);
        goodZoneStart = Math.max(0, goodZoneStart);
        goodZoneEnd = Math.min(100, goodZoneEnd);
    }

    private static String finishForging() {
        float qualityScore = AnvilMinigameOverlay.calculateQualityScore();
        String quality = AnvilMinigameOverlay.determineQuality(qualityScore);
        isVisible = false;
        minigameStarted = false;
        return quality;
    }

    public static void pauseMinigame() {
        if (minigameStarted) {
            temporaryExit = !temporaryExit;
            isVisible = !isVisible;
        }
    }

    public static void forceFinishWithPoorQuality() {
        missedHits = perfectHits + goodHits + missedHits;
        perfectHits = 0;
        goodHits = 0;
        hitsRemaining = 0;
        String quality = AnvilMinigameOverlay.finishForging();
    }

    private static float calculateQualityScore() {
        int totalHits = perfectHits + goodHits + missedHits;
        if (totalHits == 0) {
            return 0.0f;
        }
        return ((float)perfectHits * 1.0f + (float)goodHits * 0.6f) / (float)totalHits;
    }

    private static String determineQuality(float qualityScore) {
        if (qualityScore > 0.9f) {
            return "perfect";
        }
        if (qualityScore > 0.75f) {
            return "expert";
        }
        if (qualityScore > 0.5f) {
            return "well";
        }
        return "poor";
    }

    public static void endMinigame() {
        isVisible = false;
        minigameStarted = false;
        resultItem = null;
        hitsRemaining = 0;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 0.0f;
        arrowSpeed = 0.0f;
    }

    static {
        hitsRemaining = 0;
        arrowPosition = 0.0f;
        arrowSpeed = 1.0f;
        speedIncreasePerHit = 0.75f;
        movingRight = true;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        PERFECT_ZONE_START = (100 - (Integer)ServerConfig.ZONE_STARTING_SIZE.get()) / 2;
        PERFECT_ZONE_END = (100 + (Integer)ServerConfig.ZONE_STARTING_SIZE.get()) / 2;
        GOOD_ZONE_START = PERFECT_ZONE_START - 10;
        GOOD_ZONE_END = PERFECT_ZONE_END + 10;
        perfectZoneStart = PERFECT_ZONE_START;
        perfectZoneEnd = PERFECT_ZONE_END;
        goodZoneStart = GOOD_ZONE_START;
        goodZoneEnd = GOOD_ZONE_END;
        zoneShrinkFactor = 0.8f;
        zoneShiftAmount = 15.0f;
        temporaryExit = true;
        minigameStarted = false;
        ANVIL_MG = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            if (!isVisible) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            int imageWidth = 238;
            int imageHeight = 36;
            int x = (screenWidth - imageWidth) / 2;
            int y = (screenHeight - imageHeight) / 8 * 7;
            guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, imageWidth, imageHeight);
            int barX = x + 8;
            int barY = y + 9;
            int barWidth = 220;
            int barHeight = 18;
            guiGraphics.m_280509_(barX + (int)((float)(barWidth * goodZoneStart) / 100.0f), barY, barX + (int)((float)(barWidth * goodZoneEnd) / 100.0f), barY + barHeight, -2147440128);
            guiGraphics.m_280509_(barX + (int)((float)(barWidth * perfectZoneStart) / 100.0f), barY, barX + (int)((float)(barWidth * perfectZoneEnd) / 100.0f), barY + barHeight, -2147418368);
            int arrowX = barX + (int)((float)barWidth * arrowPosition / 100.0f) - 5;
            guiGraphics.m_280218_(TEXTURE, arrowX, barY - 1, 8, 39, 10, 20);
            MutableComponent stats = Component.m_237110_((String)"gui.overgeared.forging_stats", (Object[])new Object[]{hitsRemaining, perfectHits, goodHits, missedHits});
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)stats, x + 10, y - 10, -1);
        };
    }
}

