/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.block.entity.SmithingAnvilBlockEntity;
import net.stirdrem.overgeared.client.AnvilMinigameOverlay;
import net.stirdrem.overgeared.util.ModTags;
import net.stirdrem.overgeared.util.TickScheduler;
import org.jetbrains.annotations.Nullable;
import org.joml.Random;
import org.joml.Vector3f;

public class SmithingAnvil
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape Z1 = Block.m_49796_((double)3.0, (double)9.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape Z2 = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0);
    private static final VoxelShape Z3 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
    private static final VoxelShape Z4 = Block.m_49796_((double)5.0, (double)3.0, (double)3.0, (double)11.0, (double)4.0, (double)13.0);
    private static final VoxelShape Z5 = Block.m_49796_((double)6.0, (double)4.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0);
    private static final VoxelShape X1 = Block.m_49796_((double)0.0, (double)9.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape X2 = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)3.0, (double)13.0);
    private static final VoxelShape X3 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
    private static final VoxelShape X4 = Block.m_49796_((double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)4.0, (double)11.0);
    private static final VoxelShape X5 = Block.m_49796_((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.m_83124_((VoxelShape)X1, (VoxelShape[])new VoxelShape[]{X2, X3, X4, X5});
    private static final VoxelShape Z_AXIS_AABB = Shapes.m_83124_((VoxelShape)Z1, (VoxelShape[])new VoxelShape[]{Z2, Z3, Z4, Z5});
    private static final int HAMMER_SOUND_DURATION_TICKS = 0;
    private static String quality;

    public SmithingAnvil(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static String getQuality() {
        return quality;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122427_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof SmithingAnvilBlockEntity) {
            ((SmithingAnvilBlockEntity)blockEntity).drops();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        long now = level.m_46467_();
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof SmithingAnvilBlockEntity)) {
            return InteractionResult.PASS;
        }
        SmithingAnvilBlockEntity anvil = (SmithingAnvilBlockEntity)be;
        if (anvil.isBusy(now)) {
            return InteractionResult.CONSUME;
        }
        ItemStack held = player.m_21120_(hand);
        boolean isHammer = held.m_204117_(ModTags.Items.SMITHING_HAMMERS);
        if (isHammer && anvil.hasRecipe() && AnvilMinigameOverlay.isVisible) {
            for (int i = 0; i < 3; ++i) {
                int delay = 7 * i;
                TickScheduler.schedule(delay, () -> this.spawnAnvilParticles(level, pos));
            }
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            quality = AnvilMinigameOverlay.handleHit();
            anvil.tick(level, pos, state);
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)anvil, (BlockPos)pos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void spawnAnvilParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Random random = new Random();
            for (int i = 0; i < 6; ++i) {
                double offsetX = 0.5 + ((double)random.nextFloat() - 0.5);
                double offsetY = 1.0 + (double)random.nextFloat() * 0.5;
                double offsetZ = 0.5 + ((double)random.nextFloat() - 0.5);
                double velocityX = ((double)random.nextFloat() - 0.5) * 0.1;
                double velocityY = (double)random.nextFloat() * 0.1;
                double velocityZ = ((double)random.nextFloat() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 1, velocityX, velocityY, velocityZ, 1.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 1, velocityX, velocityY, velocityZ, 1.0);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SmithingAnvilBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_ && pBlockEntityType == ModBlockEntities.SMITHING_ANVIL_BE.get()) {
            return SmithingAnvil.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SMITHING_ANVIL_BE.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.updateHitsRemaining(pLevel, pPos, pState1));
        }
        return null;
    }
}

