/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stirdrem.overgeared.core.waterbarrel.BarrelInteraction;

public abstract class AbstractWaterBarrel
extends Block {
    private static final VoxelShape p1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape p2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0);
    private static final VoxelShape p3 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape p4 = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)10.0, (double)2.0);
    private static final VoxelShape p5 = Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)10.0, (double)16.0);
    private static final VoxelShape INSIDE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final VoxelShape BARREL = Shapes.m_83124_((VoxelShape)p1, (VoxelShape[])new VoxelShape[]{p2, p3, p4, p5});
    private final Map<Item, BarrelInteraction> interactions;

    public AbstractWaterBarrel(BlockBehaviour.Properties pProperties, Map<Item, BarrelInteraction> pInteractions) {
        super(pProperties);
        this.interactions = pInteractions;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BARREL;
    }

    protected double getContentHeight(BlockState pState) {
        return 0.0;
    }

    protected boolean isEntityInsideContent(BlockState pState, BlockPos pPos, Entity pEntity) {
        return pEntity.m_20186_() < (double)pPos.m_123342_() + this.getContentHeight(pState) && pEntity.m_20191_().f_82292_ > (double)pPos.m_123342_() + 0.25;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BarrelInteraction BarrelInteraction2 = this.interactions.get(itemstack.m_41720_());
        return BarrelInteraction2.interact(pState, pLevel, pPos, pPlayer, pHand, itemstack);
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return INSIDE;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public abstract boolean isFull(BlockState var1);

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Fluid fluid;
        BlockPos blockpos = PointedDripstoneBlock.m_154055_((Level)pLevel, (BlockPos)pPos);
        if (blockpos != null && (fluid = PointedDripstoneBlock.m_221849_((ServerLevel)pLevel, (BlockPos)blockpos)) != Fluids.f_76191_ && this.canReceiveStalactiteDrip(fluid)) {
            this.receiveStalactiteDrip(pState, (Level)pLevel, pPos, fluid);
        }
    }

    protected boolean canReceiveStalactiteDrip(Fluid pFluid) {
        return false;
    }

    protected void receiveStalactiteDrip(BlockState pState, Level pLevel, BlockPos pPos, Fluid pFluid) {
    }
}

