/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.atlantisweapony.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.atlantisweapony.world.features.AtlanthroneFeature;
import net.mcreator.atlantisweapony.world.features.ores.AtlanteansteeloreFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class AtlantisWeaponyModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"atlantis_weapony");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> ATLANTEANSTEELORE = AtlantisWeaponyModFeatures.register("atlanteansteelore", AtlanteansteeloreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, AtlanteansteeloreFeature.GENERATE_BIOMES, AtlanteansteeloreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ATLANTHRONE = AtlantisWeaponyModFeatures.register("atlanthrone", AtlanthroneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, AtlanthroneFeature.GENERATE_BIOMES, AtlanthroneFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

