/*
 * Decompiled with CFR 0.152.
 */
package org.multimc;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.multimc.Launcher;
import org.multimc.ParamBucket;
import org.multimc.ParseException;
import org.multimc.Utils;
import org.multimc.legacy.LegacyLauncher;
import org.multimc.onesix.OneSixLauncher;
import org.simplericity.macify.eawt.DefaultApplication;

public class EntryPoint {
    private ParamBucket m_params = new ParamBucket();
    private Launcher m_launcher;

    public static void main(String[] stringArray) {
        int n;
        Object object;
        DefaultApplication defaultApplication = new DefaultApplication();
        if (defaultApplication.isMac()) {
            try {
                object = ImageIO.read(new File("icon.png"));
                defaultApplication.setApplicationIconImage((BufferedImage)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if ((n = ((EntryPoint)(object = new EntryPoint())).listen()) != 0) {
            System.out.println("Exiting with " + n);
            System.exit(n);
        }
    }

    private Action parseLine(String string) throws ParseException {
        String[] stringArray = string.split(" ", 2);
        if (stringArray.length == 1) {
            String string2 = stringArray[0];
            if (stringArray[0].equals("launch")) {
                return Action.Launch;
            }
            if (stringArray[0].equals("abort")) {
                return Action.Abort;
            }
            throw new ParseException();
        }
        if (stringArray.length != 2) {
            throw new ParseException();
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string3.equals("launcher")) {
            if (string4.equals("legacy")) {
                this.m_launcher = new LegacyLauncher();
                Utils.log("Using legacy launcher.");
                Utils.log();
                return Action.Proceed;
            }
            if (string4.equals("onesix")) {
                this.m_launcher = new OneSixLauncher();
                Utils.log("Using onesix launcher.");
                Utils.log();
                return Action.Proceed;
            }
            throw new ParseException();
        }
        this.m_params.add(string3, string4);
        return Action.Proceed;
    }

    public int listen() {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("For some reason, your java does not support UTF-8. Consider living in the current century.");
            unsupportedEncodingException.printStackTrace();
            return 1;
        }
        boolean bl = true;
        boolean bl2 = false;
        while (bl) {
            try {
                String string = bufferedReader.readLine();
                if (string != null) {
                    Action action = this.parseLine(string);
                    if (action == Action.Abort) {
                        bl = false;
                        bl2 = true;
                    }
                    if (action != Action.Launch) continue;
                    bl = false;
                    continue;
                }
                bl = false;
                bl2 = true;
            }
            catch (IOException iOException) {
                System.err.println("Launcher ABORT due to IO exception:");
                iOException.printStackTrace();
                return 1;
            }
            catch (ParseException parseException) {
                System.err.println("Launcher ABORT due to PARSE exception:");
                parseException.printStackTrace();
                return 1;
            }
        }
        if (bl2) {
            System.err.println("Launch aborted by MultiMC.");
            return 1;
        }
        if (this.m_launcher != null) {
            return this.m_launcher.launch(this.m_params);
        }
        System.err.println("No valid launcher implementation specified.");
        return 1;
    }

    private static enum Action {
        Proceed,
        Launch,
        Abort;

    }
}

