/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import java.io.File;
import java.io.IOException;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.apache.log4j.Logger;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

public class TestInstallVersions {
    private static final Logger log = Logger.getLogger(TestInstallVersions.class);

    public static void install(Configuration conf) {
        TLauncher t;
        LocalVersionList lvl;
        if (conf.getBoolean("run.all.tlauncher.versions") || conf.getBoolean("run.all.official.versions")) {
            U.sleepFor(5000L);
            log.info("******version should be updated******");
            FileUtil.deleteDirectory(new File(MinecraftUtil.getWorkingDirectory(), "versions"));
            FileUtil.createFolder(new File(MinecraftUtil.getWorkingDirectory(), "versions"));
            TLauncher.getInstance().getVersionManager().refresh();
        }
        if (conf.getBoolean("run.all.tlauncher.versions")) {
            log.info("******runAllTLauncherVersions = true******");
            lvl = new LocalVersionList(MinecraftUtil.getWorkingDirectory());
            t = TLauncher.getInstance();
            t.getVersionManager().getVersions().stream().filter(v -> v.getAvailableVersion().getSource().equals(ClientInstanceRepo.EXTRA_VERSION_REPO) || v.getAvailableVersion().getSource().equals(ClientInstanceRepo.SKIN_VERSION_REPO)).forEach(v -> {
                log.info(v.getID());
                VersionSyncInfo vsi = t.getVersionManager().getVersionSyncInfo(v.getID());
                try {
                    lvl.saveVersion(vsi.getCompleteVersion(false).resolve(t.getVersionManager(), false));
                }
                catch (IOException e) {
                    log.warn("error", e);
                }
            });
        }
        if (conf.getBoolean("run.all.official.versions")) {
            log.info("******runAllOfficialVersions = true******");
            lvl = new LocalVersionList(MinecraftUtil.getWorkingDirectory());
            FileUtil.deleteDirectory(MinecraftUtil.getWorkingDirectory("versions"));
            t = TLauncher.getInstance();
            t.getVersionManager().getVersions(new VersionFilter(), false).stream().filter(v -> v.getAvailableVersion().getSource().equals(ClientInstanceRepo.OFFICIAL_VERSION_REPO)).forEach(v -> {
                log.info(v.getID());
                VersionSyncInfo vsi = t.getVersionManager().getVersionSyncInfo(v.getID());
                try {
                    lvl.saveVersion(vsi.getCompleteVersion(false).resolve(t.getVersionManager(), false));
                }
                catch (IOException e) {
                    log.warn("error", e);
                }
            });
        }
    }
}

