/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.updater.bootstrapper.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.DownloaderListener;
import org.tlauncher.tlauncher.ui.TLauncherFrame;
import org.tlauncher.tlauncher.updater.bootstrapper.view.UpdaterPanelProgressBar;

public class DownloadingFrameElement
extends JFrame
implements DownloaderListener {
    private final JProgressBar bar;
    private final JLabel label;
    private final LangConfiguration langConfiguration;

    public DownloadingFrameElement(LangConfiguration langConfiguration) {
        this.langConfiguration = langConfiguration;
        this.bar = new JProgressBar();
        UpdaterPanelProgressBar pan = new UpdaterPanelProgressBar();
        pan.setLayout(new BorderLayout());
        pan.setOpaque(false);
        this.label = new JLabel(langConfiguration.get("updater.frame.name"));
        this.label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.label.setFont(this.label.getFont().deriveFont(TLauncherFrame.fontSize));
        pan.add((Component)this.label, "North");
        pan.add((Component)this.bar, "Center");
        pan.add((Component)new JLabel(""), "South");
        this.setSize(new Dimension(350, 60));
        this.setResizable(false);
        this.setUndecorated(true);
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.add(pan);
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.setVisible(true);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed, double alreadyDownloaded) {
        SwingUtilities.invokeLater(() -> {
            int p = (int)progress;
            this.label.setText(this.langConfiguration.get("updater.frame.name") + " " + (int)Math.ceil(alreadyDownloaded) + " " + this.langConfiguration.get("updater.frame.speed"));
            this.bar.setValue(p);
            this.bar.repaint();
        });
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.setVisible(false);
        this.dispose();
    }
}

