/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.versions;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.swing.ResizeableComponent;
import org.tlauncher.tlauncher.ui.swing.extended.HTMLLabel;
import org.tlauncher.tlauncher.ui.versions.VersionHandler;
import org.tlauncher.util.OS;

public class VersionTipPanel
extends CenterPanel
implements LocalizableComponent,
ResizeableComponent {
    private final HTMLLabel tip = new HTMLLabel();

    VersionTipPanel(VersionHandler handler) {
        super(CenterPanel.tipTheme, CenterPanel.squareInsets);
        this.add((Component)this.tip);
        this.tip.addPropertyChangeListener("html", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o == null || !(o instanceof View)) {
                    return;
                }
                View view = (View)o;
                BasicHTML.getHTMLBaseline(view, 500 - VersionTipPanel.this.getHorizontalInsets(), 0);
            }
        });
        this.updateLocale();
    }

    @Override
    public void updateLocale() {
        this.tip.setText("");
        String text = Localizable.get("version.list.tip");
        if (text == null) {
            return;
        }
        text = text.replace("{Ctrl}", OS.OSX.isCurrent() ? "Command" : "Ctrl");
        this.tip.setText(text);
        this.onResize();
    }

    @Override
    public void onResize() {
        this.setSize(500, this.tip.getHeight() + this.getVerticalInsets());
    }

    private int getVerticalInsets() {
        return this.getInsets().top + this.getInsets().bottom;
    }

    private int getHorizontalInsets() {
        return this.getInsets().left + this.getInsets().right;
    }
}

