/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.SpringLayout;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.server.BackPanel;
import org.tlauncher.tlauncher.ui.settings.MinecraftSettings;
import org.tlauncher.tlauncher.ui.settings.ResetView;
import org.tlauncher.tlauncher.ui.settings.SettingsHandlerInterface;
import org.tlauncher.tlauncher.ui.settings.TlauncherSettings;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.ui.RadioSettingsUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class SettingsScene
extends PseudoScene {
    public static final Dimension SIZE = new Dimension(620, 529);
    private static final Color SWITCH_FOREGROUND = new Color(60, 170, 232);
    private static final Color LEFT_BUTTONS_BACKGROUND = new Color(88, 159, 42);
    public static final Color BACKGROUND = new Color(245, 245, 245);
    private final MainPane main;
    private ExtendedPanel base;
    private ButtonGroup buttonGroup = new ButtonGroup();
    public final TLauncher tlauncher;
    public final Configuration global;
    public static final Insets BUTTON_INSETS = new Insets(9, 19, 20, 19);
    public static final Insets CENTER_INSETS = new Insets(20, 19, 0, 19);
    public static String minecraft = "minecraft";
    public static String tlaucner = "tlauncher";
    private List<SettingsHandlerInterface> pages = new ArrayList<SettingsHandlerInterface>();
    JButton reset;
    private TlauncherSettings tlauncherSettings;

    public SettingsScene(MainPane main) {
        super(main);
        this.main = main;
        this.tlauncher = TLauncher.getInstance();
        this.global = this.tlauncher.getConfiguration();
        ExtendedPanel topPanel = new ExtendedPanel();
        SpringLayout sl_topPanel = new SpringLayout();
        this.base = new ExtendedPanel();
        BackPanel backPanel = new BackPanel("settings.title", new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsScene.this.main.openDefaultScene();
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        ExtendedPanel switchPanel = new ExtendedPanel();
        ExtendedPanel centerPanel = new ExtendedPanel();
        ExtendedPanel buttonPanel = new ExtendedPanel(new FlowLayout(0, 0, 0));
        MinecraftSettings minecraftSettings = (MinecraftSettings)TLauncher.getInjector().getInstance(MinecraftSettings.class);
        this.tlauncherSettings = new TlauncherSettings();
        this.pages.add(this.tlauncherSettings);
        this.pages.add(minecraftSettings);
        this.base.setSize(SIZE);
        this.base.setOpaque(true);
        this.base.setBackground(BACKGROUND);
        switchPanel.setLayout(new GridLayout(0, 2, 0, 0));
        centerPanel.setLayout(new CardLayout(0, 0));
        this.base.setLayout(new BorderLayout(0, 0));
        topPanel.setPreferredSize(new Dimension(SettingsScene.SIZE.width, 49));
        buttonPanel.setPreferredSize(new Dimension(SettingsScene.SIZE.width, 55));
        centerPanel.setInsets(CENTER_INSETS);
        buttonPanel.setInsets(BUTTON_INSETS);
        topPanel.setLayout(sl_topPanel);
        sl_topPanel.putConstraint("North", (Component)backPanel, 0, "North", (Component)topPanel);
        sl_topPanel.putConstraint("West", (Component)backPanel, 0, "West", (Component)topPanel);
        sl_topPanel.putConstraint("South", (Component)backPanel, 25, "North", (Component)topPanel);
        sl_topPanel.putConstraint("East", (Component)backPanel, 0, "East", (Component)topPanel);
        topPanel.add((Component)backPanel);
        sl_topPanel.putConstraint("North", (Component)switchPanel, 0, "South", (Component)backPanel);
        sl_topPanel.putConstraint("West", (Component)switchPanel, 0, "West", (Component)topPanel);
        sl_topPanel.putConstraint("South", (Component)switchPanel, 0, "South", (Component)topPanel);
        sl_topPanel.putConstraint("East", (Component)switchPanel, 0, "East", (Component)topPanel);
        topPanel.add((Component)switchPanel);
        centerPanel.add(minecraft, (Component)minecraftSettings);
        centerPanel.add(tlaucner, (Component)this.tlauncherSettings);
        LocalizableRadioButton button = this.createRadioButton("settings.tab.minecraft", e -> {
            CardLayout cl = (CardLayout)centerPanel.getLayout();
            cl.show(centerPanel, minecraft);
            this.repaint();
        });
        LocalizableRadioButton buttonTl = this.createRadioButton("settings.tab.tlauncher", e -> {
            CardLayout cl = (CardLayout)centerPanel.getLayout();
            cl.show(centerPanel, tlaucner);
            this.repaint();
        });
        button.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsScene.this.reset.isVisible()) {
                    SettingsScene.this.reset.setVisible(!SettingsScene.this.reset.isVisible());
                }
            }
        });
        buttonTl.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SettingsScene.this.reset.isVisible()) {
                    SettingsScene.this.reset.setVisible(!SettingsScene.this.reset.isVisible());
                }
            }
        });
        button.setSelected(true);
        switchPanel.add((Component)button);
        switchPanel.add((Component)buttonTl);
        this.fillButtons(buttonPanel);
        this.base.add((Component)centerPanel, "Center");
        this.base.add((Component)topPanel, "North");
        this.base.add((Component)buttonPanel, "South");
        this.add((Component)this.base);
        SwingUtil.changeFontFamily(backPanel, FontTL.ROBOTO_BOLD);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                for (SettingsHandlerInterface settingsHandlerInterface : SettingsScene.this.pages) {
                    settingsHandlerInterface.init();
                }
            }
        });
    }

    @Override
    public void onResize() {
        super.onResize();
        this.base.setLocation((int)((double)(this.getWidth() / 2) - SIZE.getWidth() / 2.0), (int)((double)((this.getHeight() - LoginForm.LOGIN_SIZE.height) / 2) - SIZE.getHeight() / 2.0));
    }

    private LocalizableRadioButton createRadioButton(String name, ActionListener actionListener) {
        LocalizableRadioButton button = new LocalizableRadioButton(name);
        button.setUI(new RadioSettingsUI(ImageCache.getImage((String)"background-tab-off.png")));
        button.setOpaque(true);
        button.addActionListener(actionListener);
        button.setForeground(SWITCH_FOREGROUND);
        button.setFont(button.getFont().deriveFont(1, 16.0f));
        this.buttonGroup.add(button);
        return button;
    }

    private void fillButtons(ExtendedPanel buttons) {
        Font font = new JButton().getFont().deriveFont(1, 13.0f);
        final UpdaterButton saveButton = new UpdaterButton(UpdaterButton.ORANGE_COLOR, "settings.save");
        saveButton.setFont(font);
        saveButton.addActionListener(e -> {
            for (SettingsHandlerInterface settingsHandlerInterface : this.pages) {
                if (settingsHandlerInterface.validateSettings()) continue;
                return;
            }
            boolean restart = this.restartClient();
            if (this.tlauncherSettings.chooseChinaLocal() && !restart) {
                this.main.openDefaultScene();
                return;
            }
            for (SettingsHandlerInterface settingsHandlerInterface : this.pages) {
                settingsHandlerInterface.setValues();
            }
            this.global.store();
            if (restart) {
                try {
                    Bootstrapper.restartLauncher().start();
                }
                catch (Throwable throwable) {
                    U.log(throwable);
                }
                System.exit(0);
            }
            ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).resetInfoMod();
            this.main.openDefaultScene();
        });
        saveButton.setForeground(Color.WHITE);
        final UpdaterButton defaultButton = new UpdaterButton(UpdaterButton.GREEN_COLOR, "settings.default");
        defaultButton.setFont(font);
        defaultButton.addActionListener(e -> {
            if (Alert.showLocQuestion("settings.default.warning")) {
                for (SettingsHandlerInterface settingsHandlerInterface : this.pages) {
                    settingsHandlerInterface.setDefaultSettings();
                }
            }
        });
        defaultButton.setForeground(Color.WHITE);
        int preferredHeight = 26;
        defaultButton.setPreferredSize(new Dimension(178, preferredHeight));
        saveButton.setPreferredSize(new Dimension(141, preferredHeight));
        defaultButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                defaultButton.setBackground(LEFT_BUTTONS_BACKGROUND);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                defaultButton.setBackground(defaultButton.getBackgroundColor());
            }
        });
        saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                saveButton.setBackground(ColorUtil.COLOR_204);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                saveButton.setBackground(saveButton.getBackgroundColor());
            }
        });
        this.reset = new UpdaterButton(new Color(222, 64, 43), new Color(222, 31, 8), Color.WHITE, "settings.reset.button");
        SwingUtil.setFontSize(this.reset, 13.0f, 1);
        this.reset.setPreferredSize(new Dimension(141, preferredHeight));
        this.reset.addActionListener(e -> {
            ResetView view = new ResetView();
            Alert.showMessage(Localizable.get("settings.reset.button"), view, new JButton[]{view.getResetAgain()});
        });
        this.reset.setVisible(false);
        buttons.add((Component)this.reset);
        buttons.add(Box.createHorizontalStrut(100));
        buttons.add((Component)defaultButton);
        buttons.add(Box.createHorizontalStrut(20));
        buttons.add((Component)saveButton);
    }

    private boolean restartClient() {
        if (this.tlauncherSettings.chooseChinaLocal()) {
            return Alert.showLocQuestion("tlauncher.restart", "tlauncher.restart.message");
        }
        return false;
    }
}

