/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.exceptions.ParseModPackException;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.explorer.filters.FilesAndExtentionFilter;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.GameInstallRadioButton;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.ModpackComboxRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.UserCategoryListRenderer;
import org.tlauncher.tlauncher.ui.ui.ModpackComboBoxUI;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackBackupFrame
extends TemlateModpackFrame {
    private static final long serialVersionUID = 6901167695599672717L;
    public static final SimpleDateFormat format = new SimpleDateFormat("dd-MM-YYYY-HH_mm_ss");
    private static final String RESTORER = "RESTORER";
    private static final String BACKUP = "BACKUP";
    private static final String RECOVER_FOLDER = "backup/modpacks";
    private static final Dimension DEFAULT_SIZE = new Dimension(572, 470);
    private final ModpackComboBox localModpack;
    private ButtonGroup group = new ButtonGroup();
    FileChooser explorerRecovery;
    private Color listColor = new Color(237, 249, 255);
    private JPanel subEntityPanel;
    final JList<GameEntityDTO> entitiesList;
    JComboBox<CompleteVersion> modpackBox;
    final JComboBox<GameType> modpackElementType;
    private CompleteVersion selectedVersion = null;

    public ModpackBackupFrame(JFrame parent, ModpackComboBox localModpack) {
        super(parent, "modpack.backup.title", DEFAULT_SIZE);
        this.localModpack = localModpack;
        SpringLayout springRecoverer = new SpringLayout();
        SpringLayout springBackup = new SpringLayout();
        SpringLayout springPanel = new SpringLayout();
        CardLayout cardLayout = new CardLayout();
        JPanel panel = new JPanel(springPanel);
        JPanel cardPanel = new JPanel(cardLayout);
        ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        JPanel restoredPanel = new JPanel(springRecoverer);
        JPanel backupModpackPanel = new JPanel(springBackup);
        backupModpackPanel.setBackground(Color.WHITE);
        this.addCenter(panel);
        try {
            FileUtil.createFolder(FileUtil.getRelative(RECOVER_FOLDER).toFile());
        }
        catch (IOException e1) {
            U.log(e1);
        }
        this.explorerRecovery = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
        this.explorerRecovery.setCurrentDirectory(FileUtil.getRelative(RECOVER_FOLDER).toFile());
        this.explorerRecovery.setMultiSelectionEnabled(false);
        this.explorerRecovery.setFileFilter(new FilesAndExtentionFilter("zip, rar", "zip", "rar"));
        this.modpackBox = new JComboBox();
        this.entitiesList = new JList();
        GameInstallRadioButton restoredBackup = new GameInstallRadioButton("modpack.backup.button.restore");
        GameInstallRadioButton backupModpack = new GameInstallRadioButton("modpack.backup.button.backup");
        final UpdaterButton doButton = new UpdaterButton(BLUE_COLOR, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.backup.button.do");
        UpdaterButton chooseFile = new UpdaterButton(ColorUtil.COLOR_215, "explorer.title");
        final LocalizableLabel description = new LocalizableLabel("modpack.backup.message.info");
        LocalizableLabel informationBold = new LocalizableLabel("modpack.backup.info.label.0");
        final UpdaterButton restoreButton = new UpdaterButton(BLUE_COLOR, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.backup.down.button.restore");
        ModpackScrollBarUI barUI = new ModpackScrollBarUI(){

            @Override
            protected Dimension getMinimumThumbSize() {
                return new Dimension(10, 40);
            }

            @Override
            public Dimension getMaximumSize(JComponent c) {
                Dimension dim = super.getMaximumSize(c);
                dim.setSize(10.0, dim.getHeight());
                return dim;
            }

            @Override
            public Dimension getPreferredSize(JComponent c) {
                Dimension dim = super.getPreferredSize(c);
                dim.setSize(10.0, dim.getHeight());
                return dim;
            }
        };
        barUI.setGapThubm(5);
        CardLayout cardLayout1 = new CardLayout();
        this.subEntityPanel = new JPanel(cardLayout1);
        this.subEntityPanel.setBackground(this.listColor);
        JScrollPane scroller = new JScrollPane(this.entitiesList, 20, 31);
        this.subEntityPanel.add((Component)scroller, ModpackScene.NOT_EMPTY);
        this.subEntityPanel.add((Component)new EmptyView(GameType.MOD, "modpack.table.empty."), ModpackScene.EMPTY + GameType.MOD.toString());
        this.subEntityPanel.add((Component)new EmptyView(GameType.RESOURCEPACK, "modpack.table.empty."), ModpackScene.EMPTY + (Object)((Object)GameType.RESOURCEPACK));
        this.subEntityPanel.add((Component)new EmptyView(GameType.MAP, "modpack.table.empty."), ModpackScene.EMPTY + (Object)((Object)GameType.MAP));
        this.subEntityPanel.add((Component)new EmptyView(GameType.SHADERPACK, "modpack.table.empty."), ModpackScene.EMPTY + (Object)((Object)GameType.SHADERPACK));
        this.subEntityPanel.add((Component)new EmptyView(GameType.MAP, "modpack.backup.all.elements."), "" + (Object)((Object)GameType.MODPACK) + (Object)((Object)GameType.MAP));
        this.subEntityPanel.add((Component)new EmptyView(GameType.MOD, "modpack.backup.all.elements."), "" + (Object)((Object)GameType.MODPACK) + (Object)((Object)GameType.MOD));
        this.subEntityPanel.add((Component)new EmptyView(GameType.RESOURCEPACK, "modpack.backup.all.elements."), "" + (Object)((Object)GameType.MODPACK) + (Object)((Object)GameType.RESOURCEPACK));
        this.subEntityPanel.add((Component)new EmptyView(GameType.SHADERPACK, "modpack.backup.all.elements."), "" + (Object)((Object)GameType.MODPACK) + (Object)((Object)GameType.SHADERPACK));
        scroller.getVerticalScrollBar().setUI(barUI);
        scroller.getVerticalScrollBar().setBackground(this.listColor);
        this.entitiesList.setSelectionModel(new DefaultListSelectionModel(){
            private static final long serialVersionUID = -4763682115998962110L;
            private int i0 = -1;
            private int i1 = -1;

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.i0 == index0 && this.i1 == index1) {
                    if (this.getValueIsAdjusting()) {
                        this.setValueIsAdjusting(false);
                        this.setSelection(index0, index1);
                    }
                } else {
                    this.i0 = index0;
                    this.i1 = index1;
                    this.setValueIsAdjusting(false);
                    this.setSelection(index0, index1);
                }
            }

            private void setSelection(int index0, int index1) {
                ModpackVersionDTO v = (ModpackVersionDTO)ModpackBackupFrame.this.selectedVersion.getModpack().getVersion();
                if (super.isSelectedIndex(index0)) {
                    v.getByType((GameType)((Object)ModpackBackupFrame.this.modpackElementType.getSelectedItem())).remove(ModpackBackupFrame.this.entitiesList.getModel().getElementAt(index0));
                    super.removeSelectionInterval(index0, index1);
                } else {
                    GameEntityDTO en = ModpackBackupFrame.this.entitiesList.getModel().getElementAt(index0);
                    List<? extends GameEntityDTO> list = v.getByType((GameType)((Object)ModpackBackupFrame.this.modpackElementType.getSelectedItem()));
                    list.add(en);
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
        this.entitiesList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -4696236449762079444L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                GameEntityDTO entity = (GameEntityDTO)value;
                JLabel label = new JLabel(entity.getName());
                SwingUtil.changeFontFamily(label, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
                label.setHorizontalTextPosition(4);
                label.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
                if (isSelected) {
                    label.setIcon((Icon)ImageCache.getIcon((String)"settings-check-box-on.png"));
                    label.setIconTextGap(15);
                } else {
                    label.setIconTextGap(14);
                    label.setIcon((Icon)ImageCache.getIcon((String)"settings-check-box-off.png"));
                }
                label.setPreferredSize(new Dimension(0, 30));
                label.setOpaque(false);
                return label;
            }
        });
        this.modpackElementType = new JComboBox<GameType>(new GameType[]{GameType.MOD, GameType.RESOURCEPACK, GameType.MAP, GameType.SHADERPACK});
        this.modpackBox.setRenderer(new UserCategoryListRenderer(){
            private static final long serialVersionUID = 3495501578727016309L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return this.createElement(index, isSelected, ((CompleteVersion)value).getID());
            }
        });
        this.modpackElementType.setRenderer(new UserCategoryListRenderer(){
            private static final long serialVersionUID = -6697788712085514932L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return this.createElement(index, isSelected, Localizable.get("modpack.button." + value.toString()));
            }
        });
        this.modpackElementType.setUI(new ModpackComboBoxUI(){

            @Override
            public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
                this.paintBackground(g, bounds);
                this.paintText(g, bounds, Localizable.get("modpack.button." + ModpackBackupFrame.this.modpackElementType.getSelectedItem().toString()));
            }
        });
        this.modpackBox.setUI(new ModpackComboBoxUI(){

            @Override
            public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
                this.paintBackground(g, bounds);
                this.paintText(g, bounds, ((CompleteVersion)ModpackBackupFrame.this.modpackBox.getSelectedItem()).getID());
            }
        });
        this.modpackBox.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ModpackComboxRenderer.LINE));
        this.modpackElementType.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ModpackComboxRenderer.LINE));
        restoredBackup.setActionCommand(RESTORER);
        backupModpack.setActionCommand(BACKUP);
        description.setHorizontalAlignment(0);
        description.setVerticalAlignment(1);
        informationBold.setHorizontalAlignment(0);
        this.group.add(restoredBackup);
        this.group.add(backupModpack);
        SwingUtil.changeFontFamily(restoredBackup, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(backupModpack, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(chooseFile, FontTL.ROBOTO_REGULAR, 12, Color.BLACK);
        SwingUtil.changeFontFamily(description, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(doButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(restoreButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(informationBold, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.modpackBox, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(this.modpackElementType, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(this.entitiesList, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        description.setBackground(ColorUtil.COLOR_244);
        informationBold.setBackground(ColorUtil.COLOR_244);
        restoredPanel.setBackground(Color.WHITE);
        this.entitiesList.setBackground(this.listColor);
        description.setOpaque(true);
        informationBold.setOpaque(true);
        springPanel.putConstraint("West", (Component)restoredBackup, 0, "West", (Component)panel);
        springPanel.putConstraint("East", (Component)restoredBackup, 286, "West", (Component)panel);
        springPanel.putConstraint("North", (Component)restoredBackup, 0, "North", (Component)panel);
        springPanel.putConstraint("South", (Component)restoredBackup, 58, "North", (Component)panel);
        panel.add(restoredBackup);
        springPanel.putConstraint("West", (Component)backupModpack, 286, "West", (Component)panel);
        springPanel.putConstraint("East", (Component)backupModpack, 572, "West", (Component)panel);
        springPanel.putConstraint("North", (Component)backupModpack, 0, "North", (Component)panel);
        springPanel.putConstraint("South", (Component)backupModpack, 58, "North", (Component)panel);
        panel.add(backupModpack);
        springPanel.putConstraint("West", (Component)cardPanel, 0, "West", (Component)panel);
        springPanel.putConstraint("East", (Component)cardPanel, 0, "East", (Component)panel);
        springPanel.putConstraint("North", (Component)cardPanel, 58, "North", (Component)panel);
        springPanel.putConstraint("South", (Component)cardPanel, 0, "South", (Component)panel);
        panel.add(cardPanel);
        cardPanel.add(RESTORER, restoredPanel);
        cardPanel.add(BACKUP, backupModpackPanel);
        springRecoverer.putConstraint("West", (Component)chooseFile, 179, "West", (Component)restoredPanel);
        springRecoverer.putConstraint("East", (Component)chooseFile, -177, "East", (Component)restoredPanel);
        springRecoverer.putConstraint("North", (Component)chooseFile, 39, "North", (Component)restoredPanel);
        springRecoverer.putConstraint("South", (Component)chooseFile, 77, "North", (Component)restoredPanel);
        restoredPanel.add(chooseFile);
        springRecoverer.putConstraint("West", (Component)informationBold, 0, "West", (Component)restoredPanel);
        springRecoverer.putConstraint("East", (Component)informationBold, 0, "East", (Component)restoredPanel);
        springRecoverer.putConstraint("North", (Component)informationBold, 113, "North", (Component)restoredPanel);
        springRecoverer.putConstraint("South", (Component)informationBold, 148, "North", (Component)restoredPanel);
        restoredPanel.add(informationBold);
        springRecoverer.putConstraint("West", (Component)description, 0, "West", (Component)restoredPanel);
        springRecoverer.putConstraint("East", (Component)description, 0, "East", (Component)restoredPanel);
        springRecoverer.putConstraint("North", (Component)description, 145, "North", (Component)restoredPanel);
        springRecoverer.putConstraint("South", (Component)description, 276, "North", (Component)restoredPanel);
        restoredPanel.add(description);
        springRecoverer.putConstraint("West", (Component)restoreButton, 205, "West", (Component)restoredPanel);
        springRecoverer.putConstraint("East", (Component)restoreButton, 368, "West", (Component)restoredPanel);
        springRecoverer.putConstraint("North", (Component)restoreButton, -68, "South", (Component)restoredPanel);
        springRecoverer.putConstraint("South", (Component)restoreButton, -29, "South", (Component)restoredPanel);
        restoredPanel.add(restoreButton);
        springBackup.putConstraint("West", this.modpackBox, 129, "West", (Component)backupModpackPanel);
        springBackup.putConstraint("East", this.modpackBox, -127, "East", (Component)backupModpackPanel);
        springBackup.putConstraint("North", this.modpackBox, 21, "North", (Component)backupModpackPanel);
        springBackup.putConstraint("South", this.modpackBox, 61, "North", (Component)backupModpackPanel);
        backupModpackPanel.add(this.modpackBox);
        springBackup.putConstraint("West", this.modpackElementType, 129, "West", (Component)backupModpackPanel);
        springBackup.putConstraint("East", this.modpackElementType, -127, "East", (Component)backupModpackPanel);
        springBackup.putConstraint("North", this.modpackElementType, 81, "North", (Component)backupModpackPanel);
        springBackup.putConstraint("South", this.modpackElementType, 121, "North", (Component)backupModpackPanel);
        backupModpackPanel.add(this.modpackElementType);
        springBackup.putConstraint("West", (Component)this.subEntityPanel, 129, "West", (Component)backupModpackPanel);
        springBackup.putConstraint("East", (Component)this.subEntityPanel, -127, "East", (Component)backupModpackPanel);
        springBackup.putConstraint("North", (Component)this.subEntityPanel, 121, "North", (Component)backupModpackPanel);
        springBackup.putConstraint("South", (Component)this.subEntityPanel, 271, "North", (Component)backupModpackPanel);
        backupModpackPanel.add(this.subEntityPanel);
        springBackup.putConstraint("West", (Component)doButton, 175, "West", (Component)backupModpackPanel);
        springBackup.putConstraint("East", (Component)doButton, 398, "West", (Component)backupModpackPanel);
        springBackup.putConstraint("North", (Component)doButton, -62, "South", (Component)backupModpackPanel);
        springBackup.putConstraint("South", (Component)doButton, -20, "South", (Component)backupModpackPanel);
        backupModpackPanel.add(doButton);
        restoredBackup.addActionListener(e -> cardLayout.show(cardPanel, e.getActionCommand()));
        backupModpack.addActionListener(e -> {
            if (localModpack.getItemCount() < 2) {
                this.setVisible(false);
                Alert.showLocMessage("modpack.backup.init");
                this.setVisible(true);
                restoredBackup.setSelected(true);
                return;
            }
            CompleteVersion defaultVersion = new CompleteVersion();
            defaultVersion.setID(Localizable.get("modpack.backup.modpack.box"));
            this.modpackBox.removeAllItems();
            this.modpackBox.addItem(defaultVersion);
            for (int i = 1; i < localModpack.getItemCount(); ++i) {
                this.modpackBox.addItem((CompleteVersion)localModpack.getItemAt(i));
            }
            this.modpackBox.setSelectedIndex(0);
            cardLayout.show(cardPanel, e.getActionCommand());
        });
        this.modpackBox.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                this.selectedVersion = this.modpackBox.getSelectedIndex() != 0 ? ((CompleteVersion)this.modpackBox.getSelectedItem()).fullCopy(new CompleteVersion()) : null;
                this.prepareEntityList();
            }
        });
        this.modpackElementType.addItemListener(e -> {
            if (1 == e.getStateChange()) {
                this.prepareEntityList();
            }
        });
        doButton.addActionListener(e -> {
            FileChooser f = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
            String name = this.selectedVersion == null ? "modpacks-" + format.format(new Date()) : this.selectedVersion.getID() + " " + format.format(new Date());
            name = name + ".zip";
            f.setFileFilter(new FilesAndExtentionFilter("zip format", "zip"));
            f.setDialogTitle(Localizable.get("console.save.popup"));
            f.setSelectedFile(new File(FileUtil.getRelative(RECOVER_FOLDER).toFile(), name));
            f.setMultiSelectionEnabled(false);
            this.setAlwaysOnTop(false);
            int res = f.showSaveDialog(this);
            if (res != 0) {
                return;
            }
            this.setAlwaysOnTop(true);
            doButton.setText("modpack.install.process");
            doButton.setEnabled(false);
            ArrayList<CompleteVersion> list = new ArrayList<CompleteVersion>();
            if (this.selectedVersion == null) {
                for (int i = 1; i < this.modpackBox.getItemCount(); ++i) {
                    list.add(this.modpackBox.getItemAt(i).fullCopy(new CompleteVersion()));
                }
            } else {
                list.add(this.selectedVersion);
            }
            manager.backupModPack(list, f.getSelectedFile(), new HandleListener(){

                @Override
                public void processError(Exception e) {
                    doButton.setEnabled(true);
                    doButton.setText("modpack.backup.button.do");
                    ModpackBackupFrame.this.showWarning("modpack.backup.files.error");
                }

                @Override
                public void installedSuccess(List<String> modpackNames) {
                }

                @Override
                public void operationSuccess() {
                    doButton.setEnabled(true);
                    doButton.setText("modpack.backup.button.do");
                    ModpackBackupFrame.this.setVisible(false);
                    Alert.showLocMessageWithoutTitle("modpack.backup.files.do");
                    ModpackBackupFrame.this.setVisible(true);
                }
            });
        });
        chooseFile.addActionListener(e -> {
            this.setAlwaysOnTop(false);
            if (this.explorerRecovery.showDialog(this) == 0) {
                chooseFile.setText("explorer.backup.file.chosen");
                File f = this.explorerRecovery.getSelectedFile();
                U.log("selected file " + f.toString());
                try {
                    List<String> list = manager.analizeArchiver(f);
                    description.setText(this.buildDescription(list));
                }
                catch (ParseModPackException e1) {
                    this.showWarning("modpack.install.files.error");
                    U.log(e1);
                }
            }
            this.setAlwaysOnTop(true);
        });
        restoreButton.addActionListener(e -> {
            File f = this.explorerRecovery.getSelectedFile();
            if (f == null || f.isDirectory()) {
                this.showWarning("explorer.error.choose.file");
                return;
            }
            try {
                restoreButton.setEnabled(false);
                restoreButton.setText("modpack.install.process");
                manager.installModPack(f, new HandleListener(){

                    @Override
                    public void processError(Exception e) {
                        restoreButton.setEnabled(true);
                        ModpackBackupFrame.this.showWarning("modpack.install.files.error");
                    }

                    @Override
                    public void operationSuccess() {
                    }

                    @Override
                    public void installedSuccess(List<String> modpackNames) {
                        restoreButton.setText("modpack.backup.down.button.restore");
                        restoreButton.setEnabled(true);
                        description.setText(ModpackBackupFrame.this.buildDescription(modpackNames));
                        ModpackBackupFrame.this.setVisible(false);
                        Alert.showLocMessage("modpack.install.files.installed");
                    }
                });
            }
            catch (Exception e1) {
                U.log(e1);
                this.showWarning("modpack.install.files.error");
            }
        });
        restoredBackup.setSelected(true);
        cardLayout.show(cardPanel, RESTORER);
    }

    private void showWarning(String value) {
        this.setVisible(false);
        Alert.showLocWarning(value);
        this.setVisible(true);
    }

    private void prepareEntityList() {
        DefaultListModel<GameEntityDTO> listModel = new DefaultListModel<GameEntityDTO>();
        this.entitiesList.setModel(listModel);
        if (this.selectedVersion != null) {
            ModpackVersionDTO version = (ModpackVersionDTO)this.selectedVersion.getModpack().getVersion();
            for (GameEntityDTO gameEntityDTO : version.getByType((GameType)((Object)this.modpackElementType.getSelectedItem()))) {
                listModel.addElement(gameEntityDTO);
            }
            this.entitiesList.setEnabled(true);
            if (this.entitiesList.getModel().getSize() == 0) {
                ((CardLayout)this.subEntityPanel.getLayout()).show(this.subEntityPanel, "" + ModpackScene.EMPTY + this.modpackElementType.getSelectedItem());
            } else {
                ((CardLayout)this.subEntityPanel.getLayout()).show(this.subEntityPanel, ModpackScene.NOT_EMPTY);
            }
        } else if (this.containsAnyElement((GameType)((Object)this.modpackElementType.getModel().getSelectedItem()))) {
            ((CardLayout)this.subEntityPanel.getLayout()).show(this.subEntityPanel, "" + (Object)((Object)GameType.MODPACK) + this.modpackElementType.getSelectedItem());
        } else {
            ((CardLayout)this.subEntityPanel.getLayout()).show(this.subEntityPanel, ModpackScene.EMPTY + this.modpackElementType.getSelectedItem());
        }
        int[] array = new int[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            array[i] = i;
        }
        this.entitiesList.setSelectedIndices(array);
    }

    private String buildDescription(List<String> list) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<p style='text-align: center; margin-top:5'>");
        for (String aList : list) {
            builder.append(aList).append("<br>");
        }
        builder.append("</p></html>");
        return builder.toString();
    }

    private boolean containsAnyElement(GameType type) {
        for (ModpackDTO modpackDTO : this.localModpack.getModpacks()) {
            if (((ModpackVersionDTO)modpackDTO.getVersion()).getByType(type).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private class EmptyView
    extends ExtendedPanel {
        private static final long serialVersionUID = 9216616637184943829L;

        public EmptyView(GameType gameType, String nameLoc) {
            this.setLayout(new BorderLayout());
            LocalizableLabel jLabel = new LocalizableLabel(nameLoc + (Object)((Object)gameType));
            jLabel.setHorizontalAlignment(0);
            jLabel.setAlignmentY(0.0f);
            SwingUtil.changeFontFamily(jLabel, FontTL.ROBOTO_BOLD, 14);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            this.add((Component)jLabel, "Center");
            this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, ColorUtil.COLOR_149));
        }
    }

    public static interface HandleListener {
        public void operationSuccess();

        public void processError(Exception var1);

        public void installedSuccess(List<String> var1);
    }
}

