/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.util.List;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.process.ProcessMonitorThread;

public class JavaProcess {
    private final List<String> commands;
    private final Process process;

    public JavaProcess(List<String> commands, Process process, JavaProcessListener listener) {
        this.commands = commands;
        this.process = process;
        ProcessMonitorThread monitor = new ProcessMonitorThread(this, listener);
        monitor.start();
    }

    public Process getRawProcess() {
        return this.process;
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
        return false;
    }

    public int getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException ex) {
            ex.fillInStackTrace();
            throw ex;
        }
    }

    public String toString() {
        return "JavaProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }

    public void stop() {
        this.process.destroy();
    }
}

