/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util.os;

import by.gdev.util.model.GPUDescription;
import by.gdev.util.model.GPUDriverVersion;
import by.gdev.util.model.GPUsDescriptionDTO;
import by.gdev.util.os.OSExecutor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class WindowsExecutor
implements OSExecutor {
    private static final Logger log = Logger.getLogger(WindowsExecutor.class.getName());
    private static final String UNKNOWN = "unknown";

    @Override
    public String execute(String command, int seconds) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec("cmd.exe /C chcp 437 & " + command);
        p.waitFor(seconds, TimeUnit.SECONDS);
        String res = IOUtils.toString(p.getInputStream(), "IBM437");
        p.getInputStream().close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GPUsDescriptionDTO getGPUInfo() throws IOException, InterruptedException {
        Path path = null;
        try {
            path = Files.createTempFile("dxdiag", ".txt", new FileAttribute[0]);
            String command = String.format("dxdiag /whql:off /t %s", path.toAbsolutePath());
            this.execute(command, 60);
            long size = -1L;
            for (int i = 0; i < 60; ++i) {
                Thread.sleep(500L);
                if (!Files.exists(path, new LinkOption[0])) continue;
                if (size == path.toFile().length()) break;
                size = path.toFile().length();
            }
            List<String> list = Files.readAllLines(path, Charset.forName("437"));
            GPUsDescriptionDTO gPUsDescriptionDTO = this.processSystemInfoLines(list);
            return gPUsDescriptionDTO;
        }
        finally {
            if (Objects.nonNull(path)) {
                Files.deleteIfExists(path);
            }
        }
    }

    public GPUsDescriptionDTO processSystemInfoLines(List<String> list) {
        HashSet<String> set = new HashSet<String>();
        set.add(UNKNOWN);
        ArrayList<GPUDescription> gpus = new ArrayList<GPUDescription>();
        GPUsDescriptionDTO desc = new GPUsDescriptionDTO();
        desc.setRawDescription(list.stream().collect(Collectors.joining(System.lineSeparator())));
        for (String s : list.stream().map(String::toLowerCase).collect(Collectors.toList())) {
            if (StringUtils.contains((CharSequence)s, (CharSequence)"card name:")) {
                GPUDescription g = new GPUDescription();
                g.setName(s.split(":")[1]);
                gpus.add(g);
            }
            if (gpus.size() <= 0) continue;
            if (StringUtils.contains((CharSequence)s, (CharSequence)"chip type:")) {
                ((GPUDescription)gpus.get(gpus.size() - 1)).setChipType(s.split(":")[1]);
                continue;
            }
            if (StringUtils.contains((CharSequence)s, (CharSequence)"display memory:")) {
                ((GPUDescription)gpus.get(gpus.size() - 1)).setMemory(s.split(":")[1]);
                continue;
            }
            if (!StringUtils.contains((CharSequence)s, (CharSequence)"current mode:")) continue;
            String cm = s.split(":")[1].trim();
            if (!UNKNOWN.equalsIgnoreCase(cm) && set.size() > 1) {
                gpus.remove(gpus.size() - 1);
                continue;
            }
            set.add(cm);
        }
        desc.setGpus(gpus);
        return desc;
    }

    @Override
    public GPUDriverVersion getGPUDriverVersion() throws IOException, InterruptedException {
        String[] array2;
        String[] array1;
        String res = this.execute("nvcc --version", 60);
        log.config("nvcc --version -> " + res);
        String[] array = res.split(System.lineSeparator());
        if (array.length == 5 && (array1 = array[4].trim().split(",")).length == 3 && (array2 = array1[1].trim().split(" ")).length == 2) {
            String rawCudaVersion = array2[1];
            log.config("raw cuda version " + rawCudaVersion);
            Optional<GPUDriverVersion> c = Arrays.stream(GPUDriverVersion.values()).filter(e -> e.getValue().equalsIgnoreCase("10.2")).findAny();
            if (c.isPresent()) {
                return c.get();
            }
        }
        return null;
    }
}

