/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.editor;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.LocalizableMenuItem;
import org.tlauncher.tlauncher.ui.swing.editor.ExtendedImageView;
import org.tlauncher.tlauncher.ui.swing.editor.HyperlinkProcessor;
import org.tlauncher.util.OS;

public class ExtendedHTMLEditorKit
extends HTMLEditorKit {
    protected static final ExtendedHTMLFactory extendedFactory = new ExtendedHTMLFactory();
    public static final HyperlinkProcessor defaultHyperlinkProcessor = new HyperlinkProcessor(){

        @Override
        public void process(String link) {
            URI uri;
            if (link == null) {
                return;
            }
            try {
                uri = new URI(link);
            }
            catch (URISyntaxException e) {
                Alert.showLocError("browser.hyperlink.createScrollWrapper.error", e);
                return;
            }
            OS.openLink(uri);
        }
    };
    protected final ExtendedLinkController linkController = new ExtendedLinkController();
    private HyperlinkProcessor hlProc = defaultHyperlinkProcessor;
    private boolean processPopup = true;
    private static final Cursor HAND = Cursor.getPredefinedCursor(12);
    private String popupHref;
    private final JPopupMenu popup = new JPopupMenu();

    public ExtendedHTMLEditorKit() {
        LocalizableMenuItem open = new LocalizableMenuItem("browser.hyperlink.popup.open");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedHTMLEditorKit.this.hlProc.process(ExtendedHTMLEditorKit.this.popupHref);
            }
        });
        this.popup.add(open);
        LocalizableMenuItem copy = new LocalizableMenuItem("browser.hyperlink.popup.copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ExtendedHTMLEditorKit.this.popupHref), null);
            }
        });
        this.popup.add(copy);
        LocalizableMenuItem show = new LocalizableMenuItem("browser.hyperlink.popup.show");
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Alert.showLocMessage("browser.hyperlink.popup.show.alert", ExtendedHTMLEditorKit.this.popupHref);
            }
        });
        this.popup.add(show);
    }

    @Override
    public ViewFactory getViewFactory() {
        return extendedFactory;
    }

    @Override
    public void install(JEditorPane pane) {
        super.install(pane);
        for (MouseListener listener : pane.getMouseListeners()) {
            if (!(listener instanceof HTMLEditorKit.LinkController)) continue;
            pane.removeMouseListener(listener);
            pane.removeMouseMotionListener((MouseMotionListener)((Object)listener));
            pane.addMouseListener(this.linkController);
            pane.addMouseMotionListener(this.linkController);
        }
    }

    public final boolean getProcessPopup() {
        return this.processPopup;
    }

    public final void setProcessPopup(boolean process) {
        this.processPopup = process;
    }

    private static HTML.Tag getTag(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        Object elementName = attrs.getAttribute("$ename");
        Object o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
        return o instanceof HTML.Tag ? (HTML.Tag)o : null;
    }

    private static String getAnchorHref(MouseEvent e) {
        AttributeSet anchor;
        Object hrefObject;
        Object anchorAttr;
        JEditorPane editor = (JEditorPane)e.getSource();
        if (!(editor.getDocument() instanceof HTMLDocument)) {
            return null;
        }
        HTMLDocument hdoc = (HTMLDocument)editor.getDocument();
        Element elem = hdoc.getCharacterElement(editor.viewToModel(e.getPoint()));
        HTML.Tag tag = ExtendedHTMLEditorKit.getTag(elem);
        if (tag == HTML.Tag.CONTENT && (anchorAttr = elem.getAttributes().getAttribute(HTML.Tag.A)) != null && anchorAttr instanceof AttributeSet && (hrefObject = (anchor = (AttributeSet)anchorAttr).getAttribute(HTML.Attribute.HREF)) != null && hrefObject instanceof String) {
            return (String)hrefObject;
        }
        return null;
    }

    public class ExtendedLinkController
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEnabled() && !editor.isDisplayable()) {
                return;
            }
            String href = ExtendedHTMLEditorKit.getAnchorHref(e);
            if (href == null) {
                return;
            }
            switch (e.getButton()) {
                case 3: {
                    if (!ExtendedHTMLEditorKit.this.processPopup) break;
                    ExtendedHTMLEditorKit.this.popupHref = href;
                    ExtendedHTMLEditorKit.this.popup.show(editor, e.getX(), e.getY());
                    break;
                }
                default: {
                    ExtendedHTMLEditorKit.this.hlProc.process(href);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEnabled() && !editor.isDisplayable()) {
                return;
            }
            editor.setCursor(ExtendedHTMLEditorKit.getAnchorHref(e) == null ? Cursor.getDefaultCursor() : HAND);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEnabled() && !editor.isDisplayable()) {
                return;
            }
            editor.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static class ExtendedHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag kind = ExtendedHTMLEditorKit.getTag(elem);
            if (kind == HTML.Tag.IMG) {
                return new ExtendedImageView(elem);
            }
            return super.create(elem);
        }
    }
}

