/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.versions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.LocalizableMenuItem;
import org.tlauncher.tlauncher.ui.versions.VersionHandler;
import org.tlauncher.tlauncher.ui.versions.VersionHandlerListener;
import org.tlauncher.tlauncher.ui.versions.VersionList;

public class VersionRefreshButton
extends ImageUdaterButton
implements VersionHandlerListener,
Blockable {
    private static final long serialVersionUID = -7148657244927244061L;
    private static final String PREFIX = "version.manager.refresher.";
    private static final String MENU = "version.manager.refresher.menu.";
    final VersionHandler handler;
    private final JPopupMenu menu;
    private final LocalizableMenuItem local;
    private final LocalizableMenuItem remote;
    private ButtonState state;

    VersionRefreshButton(VersionList list) {
        super(GREEN_COLOR);
        this.handler = list.handler;
        this.menu = new JPopupMenu();
        this.local = new LocalizableMenuItem("version.manager.refresher.menu.local");
        this.local.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.handler.refresh();
            }
        });
        this.menu.add(this.local);
        this.remote = new LocalizableMenuItem("version.manager.refresher.menu.remote");
        this.remote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.handler.asyncRefresh();
            }
        });
        this.menu.add(this.remote);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionRefreshButton.this.handler.asyncRefresh();
            }
        });
        this.setState(ButtonState.REFRESH);
        this.handler.addListener(this);
    }

    void onPressed() {
        switch (this.state) {
            case CANCEL: {
                this.handler.stopRefresh();
                break;
            }
            case REFRESH: {
                this.menu.show(this, 0, this.getHeight());
            }
        }
    }

    private void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setImage(state.image);
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
        this.setState(ButtonState.CANCEL);
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
        this.setState(ButtonState.REFRESH);
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
    }

    @Override
    public void onVersionDeselected() {
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    @Override
    public void block(Object reason) {
        if (!reason.equals("refresh")) {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    static enum ButtonState {
        REFRESH("refresh.png"),
        CANCEL("cancel.png");

        final Image image;

        private ButtonState(String image) {
            this.image = ImageCache.getImage((String)image);
        }
    }
}

