/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.text;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.center.CenterPanelTheme;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;

public class LocalizableTextArea
extends JTextArea
implements LocalizableComponent {
    private static final long serialVersionUID = -6319054735918918355L;
    private CenterPanelTheme theme = CenterPanel.defaultTheme;
    private String placeholder;

    public LocalizableTextArea(String placeholder, int rows, int columns) {
        super(rows, columns);
        this.setLineWrap(true);
        this.placeholder = placeholder;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LocalizableTextArea.this.setPlaceholder();
            }

            @Override
            public void focusGained(FocusEvent e) {
                LocalizableTextArea.this.setPlaceholder();
            }
        });
        this.setPlaceholder();
    }

    private void setPlaceholder() {
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            this.setForeground(this.theme.getFocusLost());
            super.setText(Localizable.get(this.placeholder));
        } else if (Localizable.get(this.placeholder).equals(this.getText())) {
            super.setText("");
            this.setForeground(this.theme.getFocus());
        }
    }

    @Override
    public void updateLocale() {
        this.setPlaceholder();
    }

    @Override
    public void setText(String t) {
        this.setForeground(this.theme.getFocus());
        super.setText(t);
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            this.setPlaceholder();
        }
    }
}

