/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.tlauncher.controller.JavaMinecraftController;
import org.tlauncher.tlauncher.entity.minecraft.MinecraftJava;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableTextField;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.text.LocalizableTextArea;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

@Singleton
public class ConfigurationJavaFrame
extends TemlateModpackFrame {
    private LocalizableTextField path;
    private LocalizableTextArea args;
    private LocalizableTextField name;
    private JTable addedJava;
    private JScrollPane scroll;
    private CardLayout cradLayout;
    JPanel topPanel;
    JPanel bottomPanel;
    @Inject
    private JavaMinecraftController controller;
    private volatile MinecraftJava.CompleteMinecraftJava j = new MinecraftJava.CompleteMinecraftJava();

    public ConfigurationJavaFrame() {
        super(TLauncher.getInstance().getFrame(), "settings.select.java", new Dimension(1000, 480));
        Font font = new JButton().getFont().deriveFont(1, 13.0f);
        this.addedJava = new JTable();
        this.scroll = new JScrollPane(this.addedJava, 20, 31);
        JavaTableModel d = new JavaTableModel();
        ExtendedPanel common = new ExtendedPanel();
        ExtendedPanel buttonsBottom = new ExtendedPanel();
        this.cradLayout = new CardLayout();
        this.topPanel = new JPanel(this.cradLayout);
        GridBagConstraints c = new GridBagConstraints();
        UpdaterButton addJava = new UpdaterButton(UpdaterButton.GRAY_COLOR, "explorer.browse");
        UpdaterButton reset = new UpdaterButton(new Color(222, 64, 43), new Color(222, 31, 8), Color.WHITE, "settings.reset.java");
        final UpdaterButton save = new UpdaterButton(UpdaterButton.ORANGE_COLOR, "settings.save");
        this.path = new LocalizableTextField();
        this.name = new LocalizableTextField("settings.java.name");
        this.args = new LocalizableTextArea("settings.java.args", 2, 0);
        this.path.setPlaceholder("settings.java.choose", Localizable.get("explorer.browse"));
        LocalizableLabel pathLabel = new LocalizableLabel("settings.java.path");
        LocalizableLabel jvmArgs = new LocalizableLabel("settings.java.args.jvm");
        LocalizableLabel nameJava = new LocalizableLabel("modpack.table.pack.element.name");
        LocalizableLabel javaNotAdded = new LocalizableLabel("settings.java.not.added");
        this.addedJava.setRowHeight(50);
        this.addedJava.setShowVerticalLines(false);
        this.addedJava.setTableHeader(null);
        this.addedJava.setModel(d);
        this.addedJava.getColumnModel().getColumn(0).setPreferredWidth(880);
        this.addedJava.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.addedJava.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.addedJava.setDefaultEditor(MinecraftJava.CompleteMinecraftJava.class, new JavaCellRenderAndEditor());
        this.addedJava.setDefaultRenderer(MinecraftJava.CompleteMinecraftJava.class, new JavaCellRenderAndEditor());
        this.addedJava.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = ConfigurationJavaFrame.this.addedJava.getSelectedRow();
                int column = ConfigurationJavaFrame.this.addedJava.getSelectedColumn();
                TableCellEditor c = ConfigurationJavaFrame.this.addedJava.getCellEditor();
                if (row == -1) {
                    return;
                }
                if (Objects.nonNull(c)) {
                    c.cancelCellEditing();
                }
                ConfigurationJavaFrame.this.addedJava.removeRowSelectionInterval(row, row);
                if (column == 2) {
                    ConfigurationJavaFrame.this.controller.remove((MinecraftJava.CompleteMinecraftJava)ConfigurationJavaFrame.this.addedJava.getModel().getValueAt(row, 0));
                } else if (column == 1) {
                    ConfigurationJavaFrame.this.j = (MinecraftJava.CompleteMinecraftJava)ConfigurationJavaFrame.this.addedJava.getModel().getValueAt(row, 0);
                    ConfigurationJavaFrame.this.path.setValue((Object)ConfigurationJavaFrame.this.j.getPath());
                    ConfigurationJavaFrame.this.name.setValue((Object)ConfigurationJavaFrame.this.j.getName());
                    ConfigurationJavaFrame.this.args.setText(ConfigurationJavaFrame.this.j.getArgs().stream().collect(Collectors.joining(" ")));
                }
            }
        });
        pathLabel.setFont(SettingElement.LABEL_FONT);
        jvmArgs.setFont(SettingElement.LABEL_FONT);
        nameJava.setFont(SettingElement.LABEL_FONT);
        javaNotAdded.setHorizontalAlignment(0);
        javaNotAdded.setAlignmentY(0.0f);
        SwingUtil.setFontSize(javaNotAdded, 18.0f, 1);
        save.setForeground(Color.WHITE);
        save.setFont(font);
        reset.setForeground(Color.WHITE);
        reset.setFont(font);
        save.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                save.setBackground(ColorUtil.COLOR_204);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                save.setBackground(save.getBackgroundColor());
            }
        });
        common.setLayout(new BoxLayout(common, 1));
        buttonsBottom.add((Component)reset, (Component)save);
        this.topPanel.add((Component)javaNotAdded, ModpackScene.EMPTY);
        this.topPanel.add((Component)this.scroll, ModpackScene.NOT_EMPTY);
        common.add((Component)this.topPanel);
        this.bottomPanel = new ExtendedPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        c.weightx = 0.1;
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 10);
        pathLabel.setHorizontalTextPosition(2);
        this.bottomPanel.add((Component)pathLabel, c);
        c.gridy = 2;
        jvmArgs.setHorizontalTextPosition(2);
        this.bottomPanel.add((Component)nameJava, c);
        c.gridy = 3;
        nameJava.setHorizontalTextPosition(2);
        this.bottomPanel.add((Component)jvmArgs, c);
        c.insets = new Insets(5, 0, 5, 10);
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 0.8;
        c.gridx = 1;
        c.gridy = 1;
        this.bottomPanel.add((Component)this.path, c);
        c.gridy = 2;
        this.bottomPanel.add((Component)this.name, c);
        c.gridy = 3;
        this.bottomPanel.add((Component)this.args, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        c.gridy = 4;
        c.anchor = 10;
        c.gridwidth = 3;
        c.gridx = 0;
        this.bottomPanel.add((Component)buttonsBottom, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 10);
        this.bottomPanel.add((Component)addJava, c);
        common.add((Component)this.bottomPanel);
        this.addCenter(common);
        addJava.addActionListener(e -> {
            FileChooser fileChooser = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
            fileChooser.setFileSelectionMode(1);
            if (Objects.nonNull(this.path.getValue())) {
                fileChooser.setCurrentDirectory(new File(this.path.getValue()));
            } else {
                fileChooser.setCurrentDirectory(OS.buildJAVAFolder().toFile());
            }
            int result = fileChooser.showDialog(this);
            if (result == 0) {
                File f = fileChooser.getSelectedFile();
                this.path.setValue((Object)f.getAbsolutePath());
                ArrayList<String> list1 = new ArrayList<String>();
                MinecraftUtil.configureG1GC(list1);
                this.args.setText(list1.stream().collect(Collectors.joining(" ")));
                this.name.setValue((Object)f.getAbsoluteFile().getName());
            }
        });
        save.addActionListener(e -> {
            String java = OS.appendBootstrapperJvm2(this.path.getValue());
            if (Objects.isNull(this.path.getValue())) {
                Alert.showError("", Localizable.get("review.message.fill") + " " + Localizable.get("settings.java.path"));
                return;
            }
            if (Files.notExists(Paths.get(java, new String[0]), new LinkOption[0])) {
                Alert.showError("", Localizable.get("settings.java.not.proper.path", java));
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.name.getValue())) {
                Alert.showError("", Localizable.get("review.message.fill") + " " + Localizable.get("modpack.table.pack.element.name"));
                return;
            }
            this.j.setPath(this.path.getValue());
            this.j.setName(this.name.getValue());
            this.j.setArgs(Arrays.asList(this.args.getText().split(" ")));
            this.controller.add(this.j);
            this.resetForm();
        });
        reset.addActionListener(e -> this.resetForm());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ConfigurationJavaFrame.this.controller.notifyListeners();
            }
        });
    }

    @Subscribe
    public void applicationEvent(MinecraftJava event) {
        SwingUtilities.invokeLater(() -> {
            if (event.getJvm().isEmpty()) {
                this.cradLayout.show(this.topPanel, ModpackScene.EMPTY);
            } else {
                this.cradLayout.show(this.topPanel, ModpackScene.NOT_EMPTY);
            }
            ((JavaTableModel)this.addedJava.getModel()).setList(Lists.newArrayList(event.getJvm().values()));
            this.addedJava.revalidate();
            this.addedJava.repaint();
        });
    }

    private void resetForm() {
        this.path.setValue((Object)"");
        this.name.setValue((Object)"");
        this.args.setText("");
        this.j = new MinecraftJava.CompleteMinecraftJava();
    }

    public class JavaCellRenderAndEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.buildComponent(row, column, (MinecraftJava.CompleteMinecraftJava)value);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.buildComponent(row, column, (MinecraftJava.CompleteMinecraftJava)value);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private Component buildComponent(int row, int column, MinecraftJava.CompleteMinecraftJava v) {
            switch (column) {
                case 0: {
                    JLabel l = new JLabel(row + 1 + ") " + Localizable.get("modpack.table.pack.element.name") + ": " + v.getName() + ". " + Localizable.get("settings.java.path") + ": " + v.getPath());
                    l.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    SwingUtil.changeFontFamily(l, FontTL.ROBOTO_MEDIUM, 13);
                    return l;
                }
                case 1: {
                    return new ImageUdaterButton(Color.WHITE, "gear.png");
                }
                case 2: {
                    return new ImageUdaterButton(Color.WHITE, "remove.png");
                }
            }
            return null;
        }
    }

    private class JavaTableModel
    extends AbstractTableModel {
        private List<MinecraftJava.CompleteMinecraftJava> list = new ArrayList<MinecraftJava.CompleteMinecraftJava>();

        @Override
        public Object getValueAt(int row, int column) {
            return this.list.get(row);
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (rowIndex == 0) {
                return super.isCellEditable(rowIndex, columnIndex);
            }
            return true;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return MinecraftJava.CompleteMinecraftJava.class;
        }

        public List<MinecraftJava.CompleteMinecraftJava> getList() {
            return this.list;
        }

        public void setList(List<MinecraftJava.CompleteMinecraftJava> list) {
            this.list = list;
        }

        public String toString() {
            return "ConfigurationJavaFrame.JavaTableModel(list=" + this.getList() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaTableModel)) {
                return false;
            }
            JavaTableModel other = (JavaTableModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<MinecraftJava.CompleteMinecraftJava> this$list = this.getList();
            List<MinecraftJava.CompleteMinecraftJava> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JavaTableModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<MinecraftJava.CompleteMinecraftJava> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }
    }
}

