/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.menu;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.managers.popup.menu.HotServerManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.menu.PopupMenuModel;
import org.tlauncher.tlauncher.ui.swing.VersionCellRenderer;
import org.tlauncher.tlauncher.ui.swing.box.TlauncherCustomBox;
import org.tlauncher.tlauncher.ui.util.ViewlUtil;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;

public class PopupMenuView
extends JPanel {
    private static final int MAX_SIZE_VERSION = 30;
    private static final Color BACKGROUND_TITLE = new Color(60, 170, 232);
    private static final Icon TLAUNCHER_USER_ICON = ImageCache.getIcon((String)"tlauncher-user.png");
    private static final Icon TLAUNCHER_USER_ICON_GRAY = ImageCache.getIcon((String)"tlauncher-user-gray.png");
    private static final Icon MOJANG_USER_ICON = ImageCache.getIcon((String)"mojang-user.png");
    private final JLabel title;
    private final JComboBox<VersionSyncInfo> box;
    private final JLabel versionLabel;
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private Point point;
    private final JLayeredPane defaultScene;
    private final PopupUpdaterButton start;
    private final PopupUpdaterButton copy;
    private final PopupUpdaterButton favorite;

    public PopupMenuView(JLayeredPane defaultScene) {
        this.setVisible(false);
        this.defaultScene = defaultScene;
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.setSize(290, 150);
        this.setBackground(Color.WHITE);
        this.versionLabel = new JLabel(Localizable.get().get("menu.version"));
        this.versionLabel.setForeground(ColorUtil.COLOR_77);
        this.box = new TlauncherCustomBox<VersionSyncInfo>();
        this.box.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return null;
            }
            boolean skin = TLauncher.getInstance().getTLauncherManager().useTLauncherAccount(value.getAvailableVersion());
            if (skin && TLauncher.getInstance().getConfiguration().getBoolean("skin.status.checkbox.state")) {
                renderer.setIcon(TLAUNCHER_USER_ICON);
            } else if (skin) {
                renderer.setIcon(TLAUNCHER_USER_ICON_GRAY);
            }
            renderer.setText(PopupMenuView.trimId(VersionCellRenderer.getLabelFor(value)));
            renderer.setAlignmentY(0.5f);
            renderer.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 0));
            renderer.setOpaque(true);
            if (isSelected) {
                renderer.setBackground(ColorUtil.COLOR_213);
            } else {
                renderer.setBackground(Color.white);
            }
            renderer.setForeground(ColorUtil.COLOR_77);
            return renderer;
        });
        this.box.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(149, 149, 149)));
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        springLayout.putConstraint("North", (Component)this.title, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.title, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.title, 30, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.title, 0, "East", (Component)this);
        this.add(this.title);
        this.title.setOpaque(true);
        this.title.setForeground(Color.WHITE);
        this.title.setBackground(BACKGROUND_TITLE);
        SwingUtil.setFontSize(this.title, 13.0f);
        this.start = new PopupUpdaterButton(Color.white, Localizable.get().get("menu.start"));
        this.start.setBorder(BorderFactory.createEmptyBorder());
        springLayout.putConstraint("North", (Component)this.start, 30, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.start, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.start, 60, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.start, 0, "East", (Component)this);
        this.add(this.start);
        this.copy = new PopupUpdaterButton(Color.white, Localizable.get().get("menu.copy"));
        this.copy.setBorder(BorderFactory.createEmptyBorder());
        springLayout.putConstraint("North", (Component)this.copy, 60, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.copy, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.copy, 90, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.copy, 0, "East", (Component)this);
        this.add(this.copy);
        this.favorite = new PopupUpdaterButton(Color.white, Localizable.get().get("menu.favorite"));
        this.favorite.setBorder(BorderFactory.createEmptyBorder());
        springLayout.putConstraint("North", (Component)this.favorite, 90, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.favorite, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.favorite, 120, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.favorite, 0, "East", (Component)this);
        this.add(this.favorite);
        springLayout.putConstraint("North", (Component)this.versionLabel, 122, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.versionLabel, 10, "West", (Component)this);
        springLayout.putConstraint("South", (Component)this.versionLabel, 146, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.versionLabel, 90, "West", (Component)this);
        this.add(this.versionLabel);
        springLayout.putConstraint("North", this.box, 122, "North", (Component)this);
        springLayout.putConstraint("West", this.box, 90, "West", (Component)this);
        springLayout.putConstraint("South", this.box, 146, "North", (Component)this);
        springLayout.putConstraint("East", this.box, -10, "East", (Component)this);
        this.add(this.box);
        HotServerManager manager = (HotServerManager)TLauncher.getInjector().getInstance(HotServerManager.class);
        this.favorite.addActionListener(e -> manager.addServerToList(true, (VersionSyncInfo)this.box.getSelectedItem()));
        this.copy.addActionListener(e -> manager.copyAddress());
        this.start.addActionListener(e -> {
            manager.launchGame((VersionSyncInfo)this.box.getSelectedItem());
            this.setVisible(false);
        });
        this.box.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                PopupMenuView.this.point = MouseInfo.getPointerInfo().getLocation();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.box.addActionListener(e -> {
            try {
                new Robot().mouseMove(this.point.x, this.point.y);
            }
            catch (AWTException e1) {
                this.log(e1);
            }
        });
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (PopupMenuView.this.isShowing() && !PopupMenuView.this.mouseIsOverDisplayPanel(PopupMenuView.this)) {
                    PopupMenuView.this.setVisible(false);
                }
            }
        };
        this.addMouseListener(m);
        this.start.addMouseListener(m);
        this.copy.addMouseListener(m);
        this.favorite.addMouseListener(m);
        this.box.addMouseListener(m);
        this.box.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (PopupMenuView.this.isShowing() && !PopupMenuView.this.mouseIsOverDisplayPanel(PopupMenuView.this)) {
                    PopupMenuView.this.setVisible(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private boolean mouseIsOverDisplayPanel(Component component) {
        if (this.box.isPopupVisible()) {
            return true;
        }
        Point c = component.getLocationOnScreen();
        Point m = MouseInfo.getPointerInfo().getLocation();
        return m.x >= c.x && m.x < c.x + component.getWidth() - 1 && m.y >= c.y && m.y <= c.y + component.getHeight();
    }

    private static String trimId(String version) {
        if (version.length() > 30) {
            return version.substring(0, 30);
        }
        return version;
    }

    private void log(Object e) {
        U.log("[PopupMenuView] ", e);
    }

    public void showSelectedModel(PopupMenuModel model) {
        SwingUtilities.invokeLater(() -> {
            String v = ViewlUtil.addSpaces(Localizable.get().get("menu.chooseVersion") + " " + model.getName(), model.getName());
            this.title.setText(v);
            this.start.setText(Localizable.get().get("menu.start"));
            this.start.setIcon(null);
            if (model.getInfo().isMojangAccount()) {
                this.start.setIcon(MOJANG_USER_ICON);
            }
            this.copy.setText(Localizable.get().get("menu.copy"));
            this.favorite.setText(Localizable.get().get("menu.favorite"));
            this.versionLabel.setText(Localizable.get().get("menu.version"));
            this.box.setModel(new DefaultComboBoxModel<VersionSyncInfo>(model.getServers().toArray(new VersionSyncInfo[0])));
            Point p = MouseInfo.getPointerInfo().getLocation();
            if (p.getY() > 680.0) {
                p.y = 680;
            }
            p = new Point(p.x - 35, p.y - 30);
            SwingUtilities.convertPointFromScreen(p, this.defaultScene);
            this.setLocation(p);
            this.setVisible(true);
        });
    }

    private class PopupUpdaterButton
    extends UpdaterButton {
        PopupUpdaterButton(Color color, String value) {
            this.setText(value);
            this.setOpaque(true);
            this.setBackground(color);
            this.setForeground(ColorUtil.COLOR_77);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    PopupUpdaterButton.this.setBackground(ColorUtil.COLOR_235);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PopupUpdaterButton.this.setBackground(Color.WHITE);
                }
            });
        }

        @Override
        protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(text, g2d);
            g.setFont(this.getFont());
            int x = 10;
            int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent();
            g2d.drawString(text, x, y);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            Icon icon = this.getIcon();
            if (Objects.nonNull(icon)) {
                icon.paintIcon(c, g, (int)(r.getWidth() + 15.0), (this.getHeight() - icon.getIconHeight()) / 2);
            }
        }
    }
}

