/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import com.google.common.base.Objects;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.entity.profile.ClientProfile;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.managers.ProfileManager;
import org.tlauncher.tlauncher.managers.ProfileManagerListener;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.swing.AccountCellRenderer;
import org.tlauncher.tlauncher.ui.swing.SimpleComboBoxModel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComboBox;
import org.tlauncher.util.U;

public class AccountComboBox
extends ExtendedComboBox<Account>
implements Blockable,
LoginProcessListener,
ProfileManagerListener {
    private static final long serialVersionUID = 6618039863712810645L;
    private static final Account EMPTY = AccountCellRenderer.EMPTY;
    private static final Account MANAGE = AccountCellRenderer.MANAGE;
    private final ProfileManager profileManager;
    private final LoginForm loginForm;
    private final SimpleComboBoxModel<Account> model;

    AccountComboBox(LoginForm lf) {
        super(new AccountCellRenderer());
        this.loginForm = lf;
        this.model = this.getSimpleModel();
        this.profileManager = TLauncher.getInstance().getProfileManager();
        this.profileManager.addListener(this);
        this.addItemListener(e -> {
            Account selected = (Account)this.getSelectedItem();
            if (selected == null || selected.equals(EMPTY)) {
                return;
            }
            if (selected.equals(MANAGE)) {
                this.loginForm.pane.openAccountEditor();
                return;
            }
            this.profileManager.selectAccount(selected);
        });
    }

    public Account getAccount() {
        Account value = (Account)this.getSelectedItem();
        return value == null || value.equals(EMPTY) ? null : value;
    }

    public void setAccount(Account account) {
        if (account == null) {
            return;
        }
        if (account.equals(this.getAccount())) {
            return;
        }
        this.setSelectedItem(account);
    }

    @Override
    public void validatePreGameLaunch() throws LoginException {
        Account account = this.getAccount();
        if (account == null || EMPTY == account || MANAGE == account) {
            this.loginForm.pane.openAccountEditor();
            Alert.showLocError("account.empty.error");
            throw new LoginException("Account list is empty!");
        }
        U.log("AccountComboBox.validte pre game launch username " + account.toString() + " " + (Object)((Object)account.getType()));
    }

    public void refreshAccounts(ClientProfile cl) {
        SwingUtilities.invokeLater(() -> {
            this.removeAllItems();
            Collection<Account> list = cl.getAccounts().values();
            if (list.isEmpty()) {
                this.addItem(EMPTY);
            } else {
                for (Account account : list) {
                    if (!Objects.equal((Object)account.getShortUUID(), (Object)cl.getSelectedAccountUUID())) continue;
                    this.model.setSelectedItem(account);
                }
                this.model.addElements(list);
            }
            this.addItem(MANAGE);
        });
    }

    @Override
    public void fireRefreshed(ClientProfile cp) {
        this.refreshAccounts(cp);
    }

    @Override
    public void fireClientProfileChanged(ClientProfile cp) {
        this.fireRefreshed(cp);
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

