/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tlauncher.util.OS;

public class Rule {
    private Action action = Action.ALLOW;
    private OSRestriction os;
    private Map<String, Object> features;

    public Rule() {
    }

    public Rule(Rule rule) {
        this.action = rule.action;
        if (rule.os != null) {
            this.os = new OSRestriction(rule.os);
        }
    }

    public Action getAppliedAction() {
        if (this.features != null && this.features.get("is_demo_user") != null) {
            return Action.DISALLOW;
        }
        if (this.os != null && !this.os.isCurrentOperatingSystem()) {
            return null;
        }
        return this.action;
    }

    public String toString() {
        return "Rule{action=" + (Object)((Object)this.action) + ", os=" + this.os + ", features=" + this.features + '}';
    }

    public class OSRestriction {
        private OS name;
        private String version;

        public OSRestriction(OSRestriction osRestriction) {
            this.name = osRestriction.name;
            this.version = osRestriction.version;
        }

        public boolean isCurrentOperatingSystem() {
            if (this.name != null && this.name != OS.CURRENT) {
                return false;
            }
            if (this.version != null) {
                try {
                    Pattern pattern = Pattern.compile(this.version);
                    Matcher matcher = pattern.matcher(System.getProperty("os.version"));
                    if (!matcher.matches()) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }

        public String toString() {
            return "OSRestriction{name=" + (Object)((Object)this.name) + ", version='" + this.version + '\'' + '}';
        }
    }

    public static enum Action {
        ALLOW,
        DISALLOW;

    }
}

