/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.entity;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.json.Argument;
import net.minecraft.launcher.versions.json.ArgumentType;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class TLauncherLib
extends Library {
    public static final String USER_CONFIG_SKIN_VERSION = "userConfigSkinVersion";
    private Pattern pattern;
    private Map<ArgumentType, List<Argument>> arguments;
    private String mainClass;
    private List<Library> requires = new ArrayList<Library>();
    private List<String> supports;
    private Set<Account.AccountType> accountTypes;
    private Map<String, MetadataDTO> downloads;

    public TLauncherLib() {
        this.setUrl("/libraries/");
    }

    public boolean matches(Library lib) {
        return this.pattern != null && this.pattern.matcher(lib.getName()).matches();
    }

    public boolean isSupport(String version) {
        if (Objects.isNull(this.supports)) {
            return false;
        }
        return this.supports.contains(version);
    }

    public boolean isProperAccountTypeLib(boolean tlAccountImpl) {
        if (Objects.isNull(this.accountTypes)) {
            return true;
        }
        if (tlAccountImpl) {
            return this.accountTypes.contains((Object)Account.AccountType.TLAUNCHER);
        }
        return this.accountTypes.contains((Object)Account.AccountType.MOJANG) || this.accountTypes.contains((Object)Account.AccountType.MICROSOFT);
    }

    public boolean isApply(Library lib, CompleteVersion v) {
        return this.matches(lib) && (Objects.isNull(this.supports) || this.isSupport(v.getID()) || v.isActivateSkinCapeForUserVersion());
    }

    @Override
    public Downloadable getDownloadable(Repo versionSource, File file, OS os) {
        U.log(new Object[]{"getting downloadable", this.getName(), versionSource, file, os});
        return super.getDownloadable(ClientInstanceRepo.EXTRA_VERSION_REPO, file, os);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<ArgumentType, List<Argument>> getArguments() {
        return this.arguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<Library> getRequires() {
        return this.requires;
    }

    public List<String> getSupports() {
        return this.supports;
    }

    public Set<Account.AccountType> getAccountTypes() {
        return this.accountTypes;
    }

    public Map<String, MetadataDTO> getDownloads() {
        return this.downloads;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setArguments(Map<ArgumentType, List<Argument>> arguments) {
        this.arguments = arguments;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setRequires(List<Library> requires) {
        this.requires = requires;
    }

    public void setSupports(List<String> supports) {
        this.supports = supports;
    }

    public void setAccountTypes(Set<Account.AccountType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public void setDownloads(Map<String, MetadataDTO> downloads) {
        this.downloads = downloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLauncherLib)) {
            return false;
        }
        TLauncherLib other = (TLauncherLib)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Pattern this$pattern = this.getPattern();
        Pattern other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Map<ArgumentType, List<Argument>> this$arguments = this.getArguments();
        Map<ArgumentType, List<Argument>> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        List<Library> this$requires = this.getRequires();
        List<Library> other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !((Object)this$requires).equals(other$requires)) {
            return false;
        }
        List<String> this$supports = this.getSupports();
        List<String> other$supports = other.getSupports();
        if (this$supports == null ? other$supports != null : !((Object)this$supports).equals(other$supports)) {
            return false;
        }
        Set<Account.AccountType> this$accountTypes = this.getAccountTypes();
        Set<Account.AccountType> other$accountTypes = other.getAccountTypes();
        if (this$accountTypes == null ? other$accountTypes != null : !((Object)this$accountTypes).equals(other$accountTypes)) {
            return false;
        }
        Map<String, MetadataDTO> this$downloads = this.getDownloads();
        Map<String, MetadataDTO> other$downloads = other.getDownloads();
        return !(this$downloads == null ? other$downloads != null : !((Object)this$downloads).equals(other$downloads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TLauncherLib;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Pattern $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Map<ArgumentType, List<Argument>> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        List<Library> $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : ((Object)$requires).hashCode());
        List<String> $supports = this.getSupports();
        result = result * 59 + ($supports == null ? 43 : ((Object)$supports).hashCode());
        Set<Account.AccountType> $accountTypes = this.getAccountTypes();
        result = result * 59 + ($accountTypes == null ? 43 : ((Object)$accountTypes).hashCode());
        Map<String, MetadataDTO> $downloads = this.getDownloads();
        result = result * 59 + ($downloads == null ? 43 : ((Object)$downloads).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TLauncherLib(super=" + super.toString() + ", pattern=" + this.getPattern() + ", arguments=" + this.getArguments() + ", mainClass=" + this.getMainClass() + ", requires=" + this.getRequires() + ", supports=" + this.getSupports() + ", accountTypes=" + this.getAccountTypes() + ", downloads=" + this.getDownloads() + ")";
    }
}

