/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.extended;

import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedUI;
import org.tlauncher.tlauncher.ui.swing.util.Orientation;

public class TabbedPane
extends JTabbedPane {
    public TabbedPane(Orientation tabLocation, TabLayout layout) {
        this.setTabLocation(tabLocation == null ? Orientation.TOP : tabLocation);
        this.setTabLayout(layout == null ? TabLayout.SCROLL : layout);
    }

    public TabbedPane() {
        this(null, null);
    }

    public ExtendedUI getExtendedUI() {
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof ExtendedUI) {
            return (ExtendedUI)((Object)ui);
        }
        return null;
    }

    public void setTabLocation(Orientation direction) {
        if (direction == null) {
            throw new NullPointerException();
        }
        this.setTabPlacement(direction.getSwingAlias());
    }

    public TabLayout getTabLayout() {
        return TabLayout.fromSwingConstant(this.getTabLayoutPolicy());
    }

    public void setTabLayout(TabLayout layout) {
        if (layout == null) {
            throw new NullPointerException();
        }
        this.setTabLayoutPolicy(layout.getSwingAlias());
    }

    public static enum TabLayout {
        WRAP(0),
        SCROLL(1);

        private final int swingAlias;

        private TabLayout(int swingAlias) {
            this.swingAlias = swingAlias;
        }

        public int getSwingAlias() {
            return this.swingAlias;
        }

        public static TabLayout fromSwingConstant(int orientation) {
            for (TabLayout current : TabLayout.values()) {
                if (orientation != current.getSwingAlias()) continue;
                return current;
            }
            return null;
        }
    }
}

