/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import org.tlauncher.tlauncher.controller.AddedModpackStuffController;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.swing.FontTL;

public class AddedModpackStuffFrame
extends TemlateModpackFrame {
    private static final Dimension DEFAULT_SIZE = new Dimension(572, 382);
    private final AddedModpackStuffController controller = (AddedModpackStuffController)TLauncher.getInjector().getInstance(AddedModpackStuffController.class);

    public AddedModpackStuffFrame(JFrame parent) {
        super(parent, "modpack.added.request", DEFAULT_SIZE);
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        panel.setBackground(Color.WHITE);
        this.addCenter(panel);
        HtmlTextPane message = HtmlTextPane.get(String.format("<div><center>%s</center></div>", Localizable.get("modpack.added.request.message")));
        message.setOpaque(false);
        UpdaterButton send = new UpdaterButton(BLUE_COLOR, BLUE_COLOR_UNDER, "log.form.send");
        final JTextField link = new JTextField();
        final CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(ColorUtil.COLOR_233, 1), BorderFactory.createEmptyBorder(0, 21, 0, 0));
        CompoundBorder redBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.RED, 1), BorderFactory.createEmptyBorder(0, 21, 0, 0));
        SwingUtil.changeFontFamily(message, FontTL.ROBOTO_REGULAR, 15, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(send, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        link.setBorder(border);
        spring.putConstraint("West", (Component)message, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)message, -27, "East", (Component)panel);
        spring.putConstraint("North", (Component)message, 40, "North", (Component)panel);
        spring.putConstraint("South", (Component)message, 170, "North", (Component)panel);
        panel.add(message);
        spring.putConstraint("West", (Component)link, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)link, -27, "East", (Component)panel);
        spring.putConstraint("North", (Component)link, 20, "South", (Component)message);
        spring.putConstraint("South", (Component)link, 66, "South", (Component)message);
        panel.add(link);
        spring.putConstraint("West", (Component)send, 175, "West", (Component)panel);
        spring.putConstraint("East", (Component)send, -174, "East", (Component)panel);
        spring.putConstraint("North", (Component)send, 20, "South", (Component)link);
        spring.putConstraint("South", (Component)send, 60, "South", (Component)link);
        panel.add(send);
        send.addActionListener(e -> {
            int code = TlauncherUtil.hostAvailabilityCheck(link.getText());
            if (code == 404 || code >= 500) {
                link.setBorder(redBorder);
                return;
            }
            this.setVisible(false);
            this.controller.send(link.getText());
        });
        link.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                link.setBorder(border);
            }
        });
    }
}

