/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc;

import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.tlauncher.tlauncher.ui.TLauncherFrame;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;

public class LocalizableCheckbox
extends JCheckBox
implements LocalizableComponent {
    private static final long serialVersionUID = 1L;
    private String path;

    public LocalizableCheckbox(String path) {
        this.init(PANEL_TYPE.LOGIN);
        this.setLabel(path);
    }

    public LocalizableCheckbox(String path, boolean state) {
        super("", state);
        this.init(PANEL_TYPE.LOGIN);
        this.setText(path);
    }

    public LocalizableCheckbox(String path2, PANEL_TYPE settings) {
        this.setText(path2);
        this.init(settings);
    }

    @Override
    @Deprecated
    public void setLabel(String path) {
        this.setText(path);
    }

    @Override
    public void setText(String path) {
        this.path = path;
        super.setText(Localizable.get() == null ? path : Localizable.get().get(path));
    }

    public String getLangPath() {
        return this.path;
    }

    public boolean getState() {
        return super.getModel().isSelected();
    }

    public void setState(boolean state) {
        super.getModel().setSelected(state);
    }

    public void addListener(ItemListener l) {
        super.getModel().addItemListener(l);
    }

    public void removeListener(ItemListener l) {
        super.getModel().removeItemListener(l);
    }

    @Override
    public void updateLocale() {
        this.setLabel(this.path);
    }

    protected void init(PANEL_TYPE panel) {
        Icon off = null;
        Icon on = null;
        switch (panel) {
            case SETTINGS: {
                on = ImageCache.getNativeIcon((String)"settings-check-box-on.png");
                off = ImageCache.getNativeIcon((String)"settings-check-box-off.png");
                break;
            }
            case LOGIN: {
                on = ImageCache.getNativeIcon((String)"checkbox-on.png");
                off = ImageCache.getNativeIcon((String)"checkbox-off.png");
            }
        }
        this.setFont(this.getFont().deriveFont(TLauncherFrame.fontSize));
        this.setOpaque(false);
        this.setIcon(off);
        this.setSelectedIcon(on);
        this.setDisabledIcon(off);
        this.setDisabledSelectedIcon(on);
        this.setPressedIcon(on);
    }

    public static enum PANEL_TYPE {
        SETTINGS,
        LOGIN;

    }
}

