/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.editor.EditorField;
import org.tlauncher.tlauncher.ui.editor.EditorIntegerField;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.scenes.SettingsScene;
import org.tlauncher.tlauncher.ui.swing.extended.BorderPanel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.ui.SettingsSliderUI;
import org.tlauncher.util.OS;

public class SettingsMemorySlider
extends BorderPanel
implements EditorField {
    public static final Color HINT_BACKGROUND_COLOR = new Color(113, 113, 113);
    private final JSlider slider;
    private final EditorIntegerField inputField;
    private final LocalizableLabel mb;
    private Configuration c;
    private JLabel question;

    SettingsMemorySlider() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        ExtendedPanel base = new ExtendedPanel();
        springLayout.putConstraint("North", (Component)base, 50, "North", (Component)this);
        springLayout.putConstraint("West", (Component)base, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)base, -236, "South", (Component)this);
        springLayout.putConstraint("East", (Component)base, 0, "East", (Component)this);
        this.add((Component)base);
        this.slider = new JSlider();
        this.slider.setOpaque(false);
        this.slider.setMinimum(512);
        this.slider.setMaximum(OS.Arch.MAX_MEMORY);
        int tick = (OS.Arch.MAX_MEMORY - 512) / 5;
        if (tick == 0) {
            this.slider.setMajorTickSpacing(1);
        } else {
            this.slider.setMajorTickSpacing(tick);
        }
        this.slider.setSnapToTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setUI(new SettingsSliderUI(this.slider));
        this.slider.setPreferredSize(new Dimension(336, 35));
        this.inputField = new EditorIntegerField();
        this.inputField.setColumns(5);
        this.mb = new LocalizableLabel("settings.java.memory.mb");
        SpringLayout spring = new SpringLayout();
        base.setLayout(spring);
        JLayeredPane sliderPanel = new JLayeredPane();
        spring.putConstraint("North", (Component)sliderPanel, 0, "North", (Component)base);
        spring.putConstraint("West", (Component)sliderPanel, 0, "West", (Component)base);
        spring.putConstraint("East", (Component)sliderPanel, -70, "East", (Component)base);
        spring.putConstraint("South", (Component)sliderPanel, 0, "South", (Component)base);
        ((Container)base).add(sliderPanel);
        spring.putConstraint("North", (Component)this.inputField, 0, "North", (Component)base);
        spring.putConstraint("West", (Component)this.inputField, 2, "East", (Component)sliderPanel);
        spring.putConstraint("East", (Component)this.inputField, 45, "East", (Component)sliderPanel);
        ((Container)base).add(this.inputField);
        spring.putConstraint("North", (Component)this.mb, 3, "North", (Component)base);
        spring.putConstraint("West", (Component)this.mb, 1, "East", (Component)this.inputField);
        spring.putConstraint("East", (Component)this.mb, 0, "East", (Component)base);
        ((Container)base).add(this.mb);
        sliderPanel.add((Component)this.slider, 0);
        this.slider.setBounds(0, 0, 336, 35);
        this.c = TLauncher.getInstance().getConfiguration();
        this.question = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        this.question.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Alert.showLocMessage(SettingsMemorySlider.this.c.get("memory.problem.message"));
            }
        });
        sliderPanel.add((Component)this.question, 1);
        this.question.setBounds(330, 0, 20, 20);
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsMemorySlider.this.updateInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        if (!TLauncher.getInstance().getConfiguration().getBoolean("settings.tip.close")) {
            this.addHint(base, spring);
        }
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SettingsMemorySlider.this.requestFocusInWindow();
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SettingsMemorySlider.this.onSliderUpdate();
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SettingsMemorySlider.this.onSliderUpdate();
            }
        });
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    private void addHint(JPanel panel_1, SpringLayout sl_panel_1) {
        int ARC_SIZE = 10;
        final JLabel crossTipButton = new JLabel(){
            BufferedImage image = ImageCache.getImage((String)"close-cross.png");

            @Override
            protected void paintComponent(Graphics g) {
                this.paint(g);
            }

            @Override
            public void paint(Graphics g0) {
                ((Graphics2D)g0).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle rec = this.getVisibleRect();
                g0.setColor(SettingsScene.BACKGROUND);
                g0.fillRect(rec.x, rec.y, rec.width, rec.height);
                g0.setColor(this.getBackground());
                g0.fillRect(rec.x, rec.y, rec.width - 10, rec.height);
                g0.fillRoundRect(rec.x, rec.y, rec.width, rec.height, 10, 10);
                6 component = this;
                this.paintPicture(g0, component, rec);
                ((Graphics2D)g0).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }

            protected void paintPicture(Graphics g, JComponent c, Rectangle rect) {
                Graphics2D g2d = (Graphics2D)g;
                int x = (this.getWidth() - this.image.getWidth(null)) / 2;
                int y = (this.getHeight() - this.image.getHeight(null)) / 2;
                g2d.drawImage((Image)this.image, x, y, null);
            }
        };
        crossTipButton.setOpaque(true);
        crossTipButton.setBackground(HINT_BACKGROUND_COLOR);
        crossTipButton.setPreferredSize(new Dimension(32, 30));
        crossTipButton.setSize(new Dimension(32, 30));
        crossTipButton.setPreferredSize(new Dimension(32, 30));
        LocalizableLabel hint = new LocalizableLabel("settings.warning");
        final ExtendedPanel extendedPanel = new ExtendedPanel(new BorderLayout(10, 0)){

            @Override
            public void paintComponent(Graphics g0) {
                Graphics2D g = (Graphics2D)g0;
                int x = 0;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(HINT_BACKGROUND_COLOR);
                g.fillRoundRect(x, x, this.getWidth(), this.getHeight(), 10, 10);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        };
        extendedPanel.setInsets(0, 5, 0, 0);
        sl_panel_1.putConstraint("East", (Component)extendedPanel, -20, "East", (Component)this.slider);
        sl_panel_1.putConstraint("North", (Component)extendedPanel, 9, "South", (Component)this.slider);
        sl_panel_1.putConstraint("South", (Component)extendedPanel, 40, "South", (Component)this.slider);
        hint.setVerticalTextPosition(0);
        hint.setHorizontalAlignment(0);
        hint.setVerticalAlignment(0);
        hint.setForeground(new Color(212, 212, 212));
        hint.setFont(hint.getFont().deriveFont(12.0f));
        extendedPanel.setOpaque(true);
        extendedPanel.add((Component)hint, "Center");
        extendedPanel.add((Component)crossTipButton, "East");
        panel_1.add(extendedPanel);
        crossTipButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> extendedPanel.setVisible(false));
                TLauncher.getInstance().getConfiguration().set("settings.tip.close", (Object)true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                crossTipButton.setBackground(new Color(124, 124, 124));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                crossTipButton.setBackground(HINT_BACKGROUND_COLOR);
            }
        });
        sl_panel_1.putConstraint("West", (Component)extendedPanel, 0, "West", (Component)panel_1);
        extendedPanel.setBackground(HINT_BACKGROUND_COLOR);
    }

    @Override
    public void setBackground(Color color) {
        if (this.inputField != null) {
            this.inputField.setBackground(color);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.slider, this.inputField);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.slider, this.inputField);
    }

    @Override
    public String getSettingsValue() {
        return this.inputField.getValue();
    }

    @Override
    public void setSettingsValue(String value) {
        this.inputField.setValue((Object)value);
        this.updateInfo();
    }

    @Override
    public boolean isValueValid() {
        return this.inputField.getIntegerValue() >= 512 && this.inputField.getIntegerValue() <= OS.Arch.MAX_MEMORY;
    }

    private void onSliderUpdate() {
        this.inputField.setValue(this.slider.getValue());
        this.updateTip();
    }

    private void updateSlider() {
        int intVal = this.inputField.getIntegerValue();
        if (intVal > 1) {
            this.slider.setValue(intVal);
        }
    }

    private void updateTip() {
    }

    private void updateInfo() {
        this.updateSlider();
        this.updateTip();
    }

    public void initMemoryQuestion() {
        if (!this.c.isExist("memory.problem.message")) {
            this.question.setVisible(false);
        }
        this.question.repaint();
    }
}

