/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.accounts.UsernameField;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.listener.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.CheckBoxListener;
import org.tlauncher.tlauncher.ui.swing.FlexibleEditorPanel;
import org.tlauncher.tlauncher.ui.text.ExtendedPasswordField;

public class AccountEditor
extends CenterPanel
implements AuthenticatorListener {
    private static final String passlock = "passlock";
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final BlockablePasswordField password;
    public final ButtonGroup authGroup;
    public static final Dimension SIZE = new Dimension(214, 221);
    public final UpdaterButton save;
    public final LinkedHashMap<Account.AccountType, AuthTypeRadio> radioMap;
    public final EditorCheckBox skinCheckBox;
    public final AuthTypeRadio mojangAuth;
    public final AuthTypeRadio tlauncherAuth;
    public final AuthTypeRadio microsoftAuth;
    public final AuthTypeRadio freeAuth;
    public static final Color FIELD_COLOR = new Color(149, 149, 149);
    private final Configuration configuration;
    private final FlexibleEditorPanel flex;
    private final JProgressBar bar = new JProgressBar();

    public AccountEditor(final AccountEditorScene sc, FlexibleEditorPanel flex) {
        super(noInsets);
        this.bar.setIndeterminate(true);
        this.bar.setVisible(false);
        this.configuration = TLauncher.getInstance().getConfiguration();
        this.scene = sc;
        this.flex = flex;
        this.username = new UsernameField((CenterPanel)this, UsernameField.UsernameState.EMAIL);
        EmptyBorder empty = new EmptyBorder(0, 9, 0, 0);
        CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(FIELD_COLOR, 1), empty);
        this.username.setBorder(border);
        this.username.setForeground(FIELD_COLOR);
        this.password = new BlockablePasswordField();
        this.password.setBorder(border);
        this.password.setEnabled(false);
        this.password.setForeground(FIELD_COLOR);
        this.authGroup = new ButtonGroup();
        this.radioMap = new LinkedHashMap();
        this.mojangAuth = new AuthTypeRadio(Account.AccountType.MOJANG);
        this.mojangAuth.setFont(this.mojangAuth.getFont().deriveFont(1));
        this.tlauncherAuth = new AuthTypeRadio(Account.AccountType.TLAUNCHER);
        this.tlauncherAuth.setFont(this.tlauncherAuth.getFont().deriveFont(1));
        this.microsoftAuth = new AuthTypeRadio(Account.AccountType.MICROSOFT);
        this.microsoftAuth.setFont(this.microsoftAuth.getFont().deriveFont(1));
        this.freeAuth = new AuthTypeRadio(Account.AccountType.FREE);
        this.freeAuth.setFont(this.freeAuth.getFont().deriveFont(1));
        this.save = new UpdaterButton(UpdaterButton.GREEN_COLOR, "account.save");
        this.save.setFont(this.save.getFont().deriveFont(1, 16.0f));
        this.save.setForeground(Color.WHITE);
        this.skinCheckBox = new EditorCheckBox("skin.status.checkbox"){

            @Override
            public void block(Object reason) {
            }

            @Override
            public void unblock(Object reason) {
            }
        };
        this.skinCheckBox.setState(this.configuration.getBoolean("skin.status.checkbox.state"));
        this.skinCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!AccountEditor.this.skinCheckBox.getState()) {
                        if (Alert.showLocQuestion("skin.status.title", "skin.status.message")) {
                            AccountEditor.this.configuration.set("skin.status.checkbox.state", false, true);
                        } else {
                            AccountEditor.this.skinCheckBox.setState(true);
                        }
                    } else {
                        Alert.showMessage(AccountEditor.this.lang.get("skin.checkbox.switch.on.title"), AccountEditor.this.lang.get("skin.checkbox.switch.on.message"));
                        AccountEditor.this.configuration.set("skin.status.checkbox.state", true, true);
                    }
                }
            }
        });
        this.setPreferredSize(SIZE);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        UsernameField panel = this.username;
        springLayout.putConstraint("North", (Component)panel, 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)panel, 20, "North", (Component)panel);
        springLayout.putConstraint("West", (Component)panel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)panel, 214, "West", (Component)this);
        this.add((Component)panel);
        AuthTypeRadio panel_1 = this.tlauncherAuth;
        springLayout.putConstraint("North", (Component)panel_1, 12, "South", (Component)panel);
        springLayout.putConstraint("South", (Component)panel_1, 15, "North", (Component)panel_1);
        springLayout.putConstraint("West", (Component)panel_1, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_1, 8, "East", (Component)panel);
        this.add((Component)panel_1);
        AuthTypeRadio panel_2 = this.mojangAuth;
        springLayout.putConstraint("North", (Component)panel_2, 12, "South", (Component)panel_1);
        springLayout.putConstraint("South", (Component)panel_2, 15, "North", (Component)panel_2);
        springLayout.putConstraint("West", (Component)panel_2, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_2, 0, "East", (Component)panel);
        this.add((Component)panel_2);
        AuthTypeRadio panel_6 = this.microsoftAuth;
        springLayout.putConstraint("North", (Component)panel_6, 12, "South", (Component)panel_2);
        springLayout.putConstraint("South", (Component)panel_6, 15, "North", (Component)panel_6);
        springLayout.putConstraint("West", (Component)panel_6, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_6, 0, "East", (Component)panel);
        this.add((Component)panel_6);
        AuthTypeRadio panel_7 = this.freeAuth;
        springLayout.putConstraint("North", (Component)panel_7, 12, "South", (Component)panel_6);
        springLayout.putConstraint("South", (Component)panel_7, 15, "North", (Component)panel_7);
        springLayout.putConstraint("West", (Component)panel_7, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_7, 0, "East", (Component)panel);
        this.add((Component)panel_7);
        BlockablePasswordField panel_3 = this.password;
        springLayout.putConstraint("North", (Component)panel_3, 12, "South", (Component)panel_7);
        springLayout.putConstraint("South", (Component)panel_3, 19, "North", (Component)panel_3);
        springLayout.putConstraint("West", (Component)panel_3, 0, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_3, 0, "East", (Component)panel);
        this.add((Component)panel_3);
        EditorCheckBox panel_5 = this.skinCheckBox;
        springLayout.putConstraint("North", (Component)panel_5, 12, "South", (Component)panel_3);
        springLayout.putConstraint("South", (Component)panel_5, 15, "North", (Component)panel_5);
        springLayout.putConstraint("West", (Component)panel_5, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_5, 0, "East", (Component)panel);
        this.add((Component)panel_5);
        this.addPanel4(this.save, springLayout, panel, panel_5);
        this.addPanel4(this.bar, springLayout, panel, panel_5);
        this.save.addActionListener(e -> {
            this.defocus();
            Account acc = this.get();
            if (acc.getUsername() == null && !acc.getType().equals((Object)Account.AccountType.MICROSOFT)) {
                Alert.showLocError("auth.error.email.account");
                return;
            }
            if (acc.getAccessToken() == null && acc.getPassword() == null && !acc.getType().equals((Object)Account.AccountType.FREE)) {
                Alert.showLocError("auth.error.nopass");
                return;
            }
            Authenticator.authenticate(acc, this);
        });
        this.microsoftAuth.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && AccountEditor.this.microsoftAuth.isEnabled()) {
                    sc.getMainPane().setScene(sc.getMainPane().microsoftAuthScene);
                }
            }
        });
    }

    private void addPanel4(JComponent component, SpringLayout springLayout, JComponent panel, JComponent panel_5) {
        springLayout.putConstraint("North", (Component)component, 9, "South", (Component)panel_5);
        springLayout.putConstraint("South", (Component)component, 26, "North", (Component)component);
        springLayout.putConstraint("West", (Component)component, 0, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)component, 0, "East", (Component)panel);
        this.add((Component)component);
    }

    public void setSelectedAccountType(Account.AccountType type) {
        AuthTypeRadio selectable = this.radioMap.get((Object)type);
        if (selectable != null) {
            selectable.setSelected(true);
        }
    }

    public void clear() {
        this.setSelectedAccountType(Account.AccountType.TLAUNCHER);
        this.username.setText(null);
        this.password.setText(null);
        this.scene.list.setTempAccountType(Account.AccountType.TLAUNCHER);
    }

    public Account get() {
        Account account = this.scene.list.getAccountFromSelected();
        account.setUsername(this.username.getValue());
        switch (account.getType()) {
            case TLAUNCHER: 
            case MOJANG: {
                if (!this.password.hasPassword()) break;
                account.setPassword(new String(this.password.getPassword()));
                break;
            }
        }
        return account;
    }

    @Override
    public void block(Object reason) {
        super.block(reason);
    }

    @Override
    public void unblock(Object reason) {
        super.unblock(reason);
    }

    public void fillFormBySelectedAccount(Account selectedValue) {
        this.username.setText(selectedValue.getDisplayName());
        this.authGroup.setSelected(this.radioMap.get((Object)selectedValue.getType()).getModel(), true);
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        this.save.setVisible(false);
        this.bar.setVisible(true);
        this.bar.setValue(0);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Exception e) {
        this.bar.setVisible(false);
        this.save.setVisible(true);
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        this.bar.setVisible(false);
        this.save.setVisible(true);
    }

    public class AuthTypeRadio
    extends LocalizableRadioButton {
        private final Account.AccountType type;

        private AuthTypeRadio(final Account.AccountType type) {
            super("account.auth." + type.toString().toLowerCase(Locale.ROOT));
            AccountEditor.this.radioMap.put(type, this);
            AccountEditor.this.authGroup.add(this);
            this.type = type;
            this.setFocusable(false);
            this.addItemListener(new CheckBoxListener(){

                @Override
                public void itemStateChanged(boolean newstate) {
                    if (newstate) {
                        ((AccountEditor)AccountEditor.this).scene.list.setTempAccountType(type);
                    }
                    if (newstate && !AccountEditor.this.password.hasPassword()) {
                        AccountEditor.this.password.setText(null);
                    }
                    if (newstate) {
                        ((AccountEditor)AccountEditor.this).scene.tip.setAccountType(type);
                        AccountEditor.this.flex.setText(Localizable.get("auth.tip." + type.name().toLowerCase(Locale.ROOT)));
                    }
                    if (Account.AccountType.FREE == type && newstate) {
                        Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, true);
                    } else {
                        Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, false);
                    }
                    AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.USERNAME : UsernameField.UsernameState.EMAIL_LOGIN);
                    if (AccountEditor.this.mojangAuth.isSelected()) {
                        AccountEditor.this.username.setState(UsernameField.UsernameState.EMAIL);
                    }
                    AccountEditor.this.defocus();
                }
            });
        }

        public Account.AccountType getAccountType() {
            return this.type;
        }
    }

    private class BlockablePasswordField
    extends ExtendedPasswordField
    implements Blockable {
        private BlockablePasswordField() {
        }

        @Override
        public void block(Object reason) {
            this.setEnabled(false);
        }

        @Override
        public void unblock(Object reason) {
            this.setEnabled(true);
        }
    }
}

